# Sistema de Gestión y Aprobación de Comisiones (Starter)

**Fecha:** 2025-09-26

## Requisitos
- PHP 8.1+ (con PDO MySQL)
- MySQL 5.7/8 o MariaDB 10.x
- Apache con `mod_rewrite` habilitado

## Instalación
1. Crea una carpeta en tu servidor local: `gestion_comisiones` y coloca el contenido de este ZIP.
2. Copia `app/config/env.example.php` a `app/config/env.php` y ajusta:
   - `BASE_URL` (p.ej. `http://localhost/gestion_comisiones/public`)
   - Credenciales de base de datos.
3. Importa `database/schema.sql` en tu MySQL.
4. Asegura `mod_rewrite` activo y que el DocumentRoot apunte a `/public` o usa la `RewriteRule` incluida.
5. Accede: `/auth/login`
   - Admin: `admin@gad.local` / `admin123`
   - Alcalde: `alcalde@gad.local` / `alcalde123`

## Módulos incluidos
- **Auth** (login/logout)
- **Dashboard**
- **Usuarios** (ADMIN) CRUD con roles/áreas/departamentos
- **Áreas** (ADMIN) CRUD
- **Departamentos** (ADMIN) CRUD dependiente de área (API `/departamento/byArea/:id`)
- **Comisiones** (Empleado crea; Alcalde/Admin aprueban o rechazan con comentario)
- **Trazabilidad** (registro básico de eventos)

## Estructura
- `public/` front-controller y .htaccess
- `app/controllers`, `app/models`, `app/views`
- `app/config/` (`env.php`, `database.php`)
- `app/core/` (`Controller.php`, `Model.php`)
- `app/helpers/` utilidades
- `database/schema.sql`

## Próximos pasos
- Adjuntos de comisión, constancias PDF, notificaciones, permisos por área.
- Auditoría avanzada y reportes.
