<?php
/**
 * Conexin PDO simple (PHP 8.x) C forzado a UTF-8 real
 */
require_once __DIR__ . '/env.php';

if (!class_exists('DB', false)) {
    final class DB {
        private static ?PDO $pdo = null;

        public static function conn(): PDO {
            if (self::$pdo === null) {
                $dsn = sprintf(
                    'mysql:host=%s;port=%s;dbname=%s;charset=utf8mb4',
                    DB_HOST, DB_PORT, DB_NAME
                );

                $options = [
                    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES   => false,
                    // fuerza juego de caracteres en el handshake
                    PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4 COLLATE utf8mb4_general_ci",
                ];

                self::$pdo = new PDO($dsn, DB_USER, DB_PASS, $options);

                // doble seguridad (no rompe nada si ya viene del INIT_COMMAND)
                self::$pdo->exec("SET NAMES utf8mb4");
                self::$pdo->exec("SET CHARACTER SET utf8mb4");
                self::$pdo->exec("SET collation_connection = 'utf8mb4_general_ci'");
            }
            return self::$pdo;
        }
    }
}
