<?php
class AreaController extends Controller {
    public function index(): void { require_login(); if (!has_role('ADMIN')) { http_response_code(403); exit('No autorizado'); }
        $areas = (new Area())->all();
        $this->view('area/index', compact('areas'));
    }
    public function create(): void { require_login(); if (!has_role('ADMIN')) { http_response_code(403); exit('No autorizado'); }
        if (is_post()) {
            $nombre = trim($_POST['nombre']??'');
            $id = (new Area())->create($nombre);
            (new Trazabilidad())->log('AREAS','CREAR', user()['id'], $id, $nombre);
            redirect('/area/index');
        }
        $this->view('area/create');
    }
    public function edit(int $id): void { require_login(); if (!has_role('ADMIN')) { http_response_code(403); exit('No autorizado'); }
        if (is_post()) {
            $nombre = trim($_POST['nombre']??'');
            (new Area())->update($id,$nombre);
            (new Trazabilidad())->log('AREAS','EDITAR', user()['id'], $id, $nombre);
            redirect('/area/index');
        }
        $areas = (new Area())->all();
        $area = null;
        foreach ($areas as $a) if ((int)$a['id']===$id) { $area=$a; break; }
        $this->view('area/edit', compact('area'));
    }
    public function delete(int $id): void { require_login(); if (!has_role('ADMIN')) { http_response_code(403); exit('No autorizado'); }
        (new Area())->softDelete($id);
        (new Trazabilidad())->log('AREAS','ELIMINAR', user()['id'], $id, '');
        redirect('/area/index');
    }
}
