<?php
class AuthController extends Controller {
 public function login(): void {
    if (user()) { redirect('/dashboard'); }

    $error = null; // <-- ✅ inicializa

    if (is_post()) {
        require_once __DIR__ . '/../models/User.php';
        $email = trim($_POST['email'] ?? '');
        $pass  = trim($_POST['password'] ?? '');
        $u = (new User())->findByEmail($email);
        if ($u && password_verify($pass, $u['contrasena'])) {
            $_SESSION['user'] = $u;
            redirect('/dashboard');
        } else {
            $error = "Credenciales inválidas.";
        }
    }
    // Puedes usar compact o un array explícito
    $this->view('auth/login', compact('error')); // o: $this->view('auth/login', ['error'=>$error]);
}

    public function logout(): void {
        if (session_status() === PHP_SESSION_NONE) session_start();
        $_SESSION = [];
        session_destroy();
        redirect('/auth/login');
    }
}
