<?php
declare(strict_types=1);

require_once __DIR__ . '/../models/ComisionConstancia.php';

class ConstanciaController extends Controller
{
    private function baseUrl(): string {
        return rtrim((string)(defined('BASE_URL') ? BASE_URL : ''), '/');
    }

    /** GET /constancia/verificar/{codigo}  (pública, sin login) */
    public function verificar(string $codigo): void
    {
        $mConst = new ComisionConstancia();
        // Asegúrate de tener este método en el modelo; si no, usa una consulta directa.
        if (!method_exists($mConst, 'findByCodigo')) {
            // Fallback genérico
            $db = DB::conn();
            $st = $db->prepare("SELECT * FROM comision_constancias WHERE codigo=? LIMIT 1");
            $st->execute([$codigo]);
            $const = $st->fetch();
        } else {
            $const = $mConst->findByCodigo($codigo);
        }

        if (!$const) {
            http_response_code(404);
            echo "<!doctype html><meta charset='utf-8'><title>No encontrada</title>
                  <style>body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,'Apple Color Emoji','Segoe UI Emoji';padding:20px;color:#1f2937;background:#f3f4f6}
                  .card{max-width:720px;margin:auto;background:#fff;border:1px solid #e5e7eb;border-radius:12px;padding:16px}</style>
                  <div class='card'><h2>Constancia no encontrada</h2>
                  <p>El código <b>".htmlspecialchars($codigo)."</b> no existe o fue anulado.</p></div>";
            return;
        }

        $estado   = strtoupper($const['estado'] ?? 'GENERADA');
        $valida   = ($estado === 'FIRMADA' || $estado === 'GENERADA');
        $ok       = $valida ? '✅ VÁLIDA' : '❌ NO VÁLIDA';
        $pdf      = htmlspecialchars((string)($const['pdf_path'] ?? $const['pdf_url'] ?? ''));
        $firmado  = htmlspecialchars((string)($const['firmado_path'] ?? $const['firmado_url'] ?? ''));
        $codigoHx = htmlspecialchars((string)$const['codigo']);

        echo "<!doctype html><meta charset='utf-8'><title>Verificación {$codigoHx}</title>
        <style>
          body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,'Apple Color Emoji','Segoe UI Emoji';padding:20px;color:#1f2937;background:#f3f4f6}
          .card{max-width:820px;margin:auto;background:#fff;border:1px solid #e5e7eb;border-radius:12px;padding:16px}
          .muted{color:#6b7280}
          a.btn{display:inline-block;margin-right:8px;padding:8px 12px;border:1px solid #cbd5e1;border-radius:10px;text-decoration:none;color:#111827;background:#fff}
        </style>
        <div class='card'>
          <h2>Verificación de constancia</h2>
          <p><b>Código:</b> {$codigoHx}</p>
          <p><b>Estado:</b> {$ok} <span class='muted'>(actual: ".htmlspecialchars($estado).")</span></p>
          <p><b>Generada el:</b> ".htmlspecialchars($const['created_at'] ?? '')."</p>
          <p><b>Documento:</b> ".($pdf ? "<a class='btn' target='_blank' href='{$pdf}'>Abrir constancia</a>" : "<span class='muted'>No disponible</span>")."
             ".($firmado ? "<a class='btn' target='_blank' href='{$firmado}'>PDF firmado</a>" : "")."
          </p>
          <p class='muted'>Este portal permite a terceros validar la existencia y el estado de una constancia emitida por el Sistema de Gestión de Comisiones.</p>
        </div>";
    }
}
