<?php
class DepartamentoController extends Controller {
    public function index(): void { require_login(); if (!has_role('ADMIN')) { http_response_code(403); exit('No autorizado'); }
        $items = (new Departamento())->allWithArea();
        $areas = (new Area())->all();
        $this->view('departamento/index', compact('items','areas'));
    }
    public function create(): void { require_login(); if (!has_role('ADMIN')) { http_response_code(403); exit('No autorizado'); }
        $areas = (new Area())->all();
        if (is_post()) {
            $data = ['area_id'=>(int)($_POST['area_id']??0),'nombre'=>trim($_POST['nombre']??'')];
            $id = (new Departamento())->create($data);
            (new Trazabilidad())->log('DEPARTAMENTOS','CREAR', user()['id'], $id, $data['nombre']);
            redirect('/departamento/index');
        }
        $this->view('departamento/create', compact('areas'));
    }
    public function edit(int $id): void { require_login(); if (!has_role('ADMIN')) { http_response_code(403); exit('No autorizado'); }
        $areas = (new Area())->all();
        if (is_post()) {
            $data = ['area_id'=>(int)($_POST['area_id']??0),'nombre'=>trim($_POST['nombre']??'')];
            (new Departamento())->update($id,$data);
            (new Trazabilidad())->log('DEPARTAMENTOS','EDITAR', user()['id'], $id, $data['nombre']);
            redirect('/departamento/index');
        }
        $items = (new Departamento())->allWithArea();
        $dep = null; foreach ($items as $i) if ((int)$i['id']===$id) { $dep=$i; break; }
        $this->view('departamento/edit', compact('dep','areas'));
    }
    public function delete(int $id): void { require_login(); if (!has_role('ADMIN')) { http_response_code(403); exit('No autorizado'); }
        (new Departamento())->softDelete($id);
        (new Trazabilidad())->log('DEPARTAMENTOS','ELIMINAR', user()['id'], $id, '');
        redirect('/departamento/index');
    }
    // API simple para combo dependiente
    public function byArea(int $areaId): void { require_login();
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode((new Departamento())->byArea($areaId));
    }
}
