<?php
class UserController extends Controller {
    public function index(): void { require_login(); if (!has_role('ADMIN')) { http_response_code(403); exit('No autorizado'); }
        require_once __DIR__ . '/../models/User.php';
        $users = (new User())->all();
        $this->view('user/index', compact('users'));
    }
    public function create(): void { require_login(); if (!has_role('ADMIN')) { http_response_code(403); exit('No autorizado'); }
        require_once __DIR__ . '/../models/Role.php';
        require_once __DIR__ . '/../models/Area.php';
        require_once __DIR__ . '/../models/Departamento.php';
        $roles = (new Role())->all();
        $areas = (new Area())->all();
        $departamentos = []; // por JS al seleccionar área
        if (is_post()) {
            require_once __DIR__ . '/../models/User.php';
            $data = [
                'nombre'=>trim($_POST['nombre']??''),
                'email'=>trim($_POST['email']??''),
                'contrasena'=>password_hash(trim($_POST['password']??''), PASSWORD_DEFAULT),
                'rol_id'=>(int)($_POST['rol_id']??0),
                'area_id'=>(int)($_POST['area_id']??0),
                'department_id'=>(int)($_POST['department_id']??0),
                'cargo'=>trim($_POST['cargo']??'')
            ];
            $id = (new User())->create($data);
            (new Trazabilidad())->log('USUARIOS','CREAR', user()['id'], $id, $data['email']);
            redirect('/user/index');
        }
        $this->view('user/create', compact('roles','areas','departamentos'));
    }
    public function edit(int $id): void { require_login(); if (!has_role('ADMIN')) { http_response_code(403); exit('No autorizado'); }
        require_once __DIR__ . '/../models/User.php';
        require_once __DIR__ . '/../models/Role.php';
        require_once __DIR__ . '/../models/Area.php';
        require_once __DIR__ . '/../models/Departamento.php';
        $user = (new User())->find($id);
        if (!$user) { http_response_code(404); exit('Usuario no encontrado'); }
        $roles = (new Role())->all();
        $areas = (new Area())->all();
        $departamentos = (new Departamento())->byArea((int)$user['area_id']);
        if (is_post()) {
            $data = [
                'nombre'=>trim($_POST['nombre']??''),
                'email'=>trim($_POST['email']??''),
                'rol_id'=>(int)($_POST['rol_id']??0),
                'area_id'=>(int)($_POST['area_id']??0),
                'department_id'=>(int)($_POST['department_id']??0),
                'cargo'=>trim($_POST['cargo']??''),
                'contrasena'=>trim($_POST['password']??'')
            ];
            if ($data['contrasena']) $data['contrasena'] = password_hash($data['contrasena'], PASSWORD_DEFAULT);
            else unset($data['contrasena']);
            (new User())->update($id,$data);
            (new Trazabilidad())->log('USUARIOS','EDITAR', user()['id'], $id, $data['email']);
            redirect('/user/index');
        }
        $this->view('user/edit', compact('user','roles','areas','departamentos'));
    }
    public function delete(int $id): void { require_login(); if (!has_role('ADMIN')) { http_response_code(403); exit('No autorizado'); }
        require_once __DIR__ . '/../models/User.php';
        (new User())->softDelete($id);
        (new Trazabilidad())->log('USUARIOS','ELIMINAR', user()['id'], $id, '');
        redirect('/user/index');
    }
}
