<?php
function h(?string $v): string { return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
function redirect(string $path): void { header("Location: " . BASE_URL . $path); exit; }
function is_post(): bool { return ($_SERVER['REQUEST_METHOD'] ?? '') === 'POST'; }
function require_login(): void {
    if (session_status() === PHP_SESSION_NONE) session_start();
    if (!isset($_SESSION['user'])) {
        redirect('/auth/login');
    }
}
function user(): ?array {
    if (session_status() === PHP_SESSION_NONE) session_start();
    return $_SESSION['user'] ?? null;
}
function has_role(string $role): bool {
    $u = user();
    return $u && strtoupper($u['rol']) === strtoupper($role);
}
