<?php
class Area extends Model {
    public function all(): array {
        return $this->db->query("SELECT * FROM areas WHERE deleted_at IS NULL ORDER BY nombre")->fetchAll();
    }
    public function create(string $nombre): int {
        $stmt = $this->db->prepare("INSERT INTO areas (nombre,created_at) VALUES (?,NOW())");
        $stmt->execute([$nombre]);
        return (int)$this->db->lastInsertId();
    }
    public function update(int $id, string $nombre): bool {
        $stmt = $this->db->prepare("UPDATE areas SET nombre=? WHERE id=?");
        return $stmt->execute([$nombre,$id]);
    }
    public function softDelete(int $id): bool {
        $stmt = $this->db->prepare("UPDATE areas SET deleted_at=NOW() WHERE id=?");
        return $stmt->execute([$id]);
    }
}
