<?php
class ComisionConstancia extends Model {
    public function create(int $comisionId, string $codigo, string $pdfPath, string $qrText, ?string $hash = null): int {
        $stmt = $this->db->prepare("INSERT INTO comision_constancias
            (comision_id, codigo, pdf_path, qr_text, hash_doc, estado) VALUES (?,?,?,?,?, 'GENERADA')");
        $stmt->execute([$comisionId, $codigo, $pdfPath, $qrText, $hash]);
        return (int)$this->db->lastInsertId();
    }

    public function findByComision(int $comisionId): ?array {
        $stmt = $this->db->prepare("SELECT * FROM comision_constancias WHERE comision_id=? ORDER BY id DESC LIMIT 1");
        $stmt->execute([$comisionId]);
        $r = $stmt->fetch();
        return $r ?: null;
    }

    public function find(int $id): ?array {
        $stmt = $this->db->prepare("SELECT * FROM comision_constancias WHERE id=?");
        $stmt->execute([$id]);
        $r = $stmt->fetch();
        return $r ?: null;
    }

    public function setFirmado(int $id, string $path): bool {
        $stmt = $this->db->prepare("UPDATE comision_constancias SET firmado_path=?, estado='FIRMADA' WHERE id=?");
        return $stmt->execute([$path, $id]);
    }
}
