<?php
class Departamento extends Model {
    public function allWithArea(): array {
        $sql = "SELECT d.*, a.nombre AS area_nombre
                FROM departamentos d
                LEFT JOIN areas a ON a.id = d.area_id
                WHERE d.deleted_at IS NULL
                ORDER BY d.id DESC";
        return $this->db->query($sql)->fetchAll();
    }
    public function byArea(int $areaId): array {
        $stmt = $this->db->prepare("SELECT * FROM departamentos WHERE area_id=? AND deleted_at IS NULL ORDER BY nombre");
        $stmt->execute([$areaId]);
        return $stmt->fetchAll();
    }
    public function create(array $data): int {
        $stmt = $this->db->prepare("INSERT INTO departamentos (area_id,nombre,created_at) VALUES (?,?,NOW())");
        $stmt->execute([$data['area_id'],$data['nombre']]);
        return (int)$this->db->lastInsertId();
    }
    public function update(int $id, array $data): bool {
        $stmt = $this->db->prepare("UPDATE departamentos SET area_id=?, nombre=? WHERE id=?");
        return $stmt->execute([$data['area_id'],$data['nombre'],$id]);
    }
    public function softDelete(int $id): bool {
        $stmt = $this->db->prepare("UPDATE departamentos SET deleted_at=NOW() WHERE id=?");
        return $stmt->execute([$id]);
    }
}
