<?php
class Trazabilidad extends Model {
    public function log(string $modulo, string $accion, int $userId, ?int $refId = null, string $detalle=''): void {
        $stmt = $this->db->prepare("INSERT INTO trazabilidad (modulo,accion,usuario_id,ref_id,detalle,fecha_hora)
                                    VALUES (?,?,?,?,?,NOW())");
        $stmt->execute([$modulo,$accion,$userId,$refId,$detalle]);
    }
    public function byModulo(string $modulo, int $limit=100): array {
        $stmt = $this->db->prepare("SELECT t.*, u.nombre AS usuario FROM trazabilidad t
                                    LEFT JOIN users u ON u.id=t.usuario_id
                                    WHERE modulo=? ORDER BY t.id DESC LIMIT ?");
        $stmt->bindValue(1,$modulo);
        $stmt->bindValue(2,$limit,PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll();
    }
}
