<?php
class User extends Model {
    public function all(): array {
        $sql = "SELECT u.*, a.nombre AS area_nombre, d.nombre AS depto_nombre, r.nombre AS rol
                FROM users u
                LEFT JOIN areas a ON a.id = u.area_id
                LEFT JOIN departamentos d ON d.id = u.department_id
                LEFT JOIN roles r ON r.id = u.rol_id
                WHERE u.deleted_at IS NULL
                ORDER BY u.id DESC";
        return $this->db->query($sql)->fetchAll();
    }
    public function find(int $id): ?array {
        $stmt = $this->db->prepare("SELECT * FROM users WHERE id=? AND deleted_at IS NULL");
        $stmt->execute([$id]);
        $row = $stmt->fetch();
        return $row ?: null;
    }
    public function findByEmail(string $email): ?array {
        $stmt = $this->db->prepare("SELECT u.*, r.nombre AS rol FROM users u
                                    LEFT JOIN roles r ON r.id = u.rol_id
                                    WHERE u.email=? AND u.deleted_at IS NULL");
        $stmt->execute([$email]);
        $row = $stmt->fetch();
        return $row ?: null;
    }
    public function create(array $data): int {
        $stmt = $this->db->prepare("INSERT INTO users (nombre,email,contrasena,rol_id,area_id,department_id,cargo,created_at)
                                    VALUES (?,?,?,?,?,?,?,NOW())");
        $stmt->execute([
            $data['nombre'],$data['email'],$data['contrasena'],$data['rol_id'],
            $data['area_id'] ?: null,$data['department_id'] ?: null,$data['cargo'] ?: null
        ]);
        return (int)$this->db->lastInsertId();
    }
    public function update(int $id, array $data): bool {
        $sql = "UPDATE users SET nombre=?, email=?, rol_id=?, area_id=?, department_id=?, cargo=?";
        $args = [$data['nombre'],$data['email'],$data['rol_id'],$data['area_id'] ?: null,$data['department_id'] ?: null,$data['cargo'] ?: null];
        if (!empty($data['contrasena'])) { $sql .= ", contrasena=?"; $args[] = $data['contrasena']; }
        $sql .= " WHERE id=?"; $args[] = $id;
        $stmt = $this->db->prepare($sql);
        return $stmt->execute($args);
    }
    public function softDelete(int $id): bool {
        $stmt = $this->db->prepare("UPDATE users SET deleted_at=NOW() WHERE id=?");
        return $stmt->execute([$id]);
    }
}
