<?php require __DIR__ . '/../layout/header.php'; ?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <h1 class="h5 mb-0"><i class="ti ti-building"></i> Áreas</h1>
  <a class="btn btn-primary" href="<?= h(BASE_URL) ?>/area/create"><i class="ti ti-plus"></i> Nueva</a>
</div>
<div class="card shadow-sm">
  <div class="table-responsive">
    <table class="table align-middle mb-0">
      <thead class="table-light"><tr><th>#</th><th>Nombre</th><th></th></tr></thead>
      <tbody>
        <?php foreach($areas as $a): ?>
        <tr>
          <td><?= (int)$a['id'] ?></td>
          <td><?= h($a['nombre']) ?></td>
          <td class="text-end">
            <a class="btn btn-sm btn-outline-primary" href="<?= h(BASE_URL) ?>/area/edit/<?= (int)$a['id'] ?>"><i class="ti ti-edit"></i></a>
            <a class="btn btn-sm btn-outline-danger" href="<?= h(BASE_URL) ?>/area/delete/<?= (int)$a['id'] ?>" onclick="return confirm('¿Eliminar área?')"><i class="ti ti-trash"></i></a>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require __DIR__ . '/../layout/footer.php'; ?>
