<?php if (session_status() === PHP_SESSION_NONE) session_start(); ?>
<?php
  if (!function_exists('h')) { function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES,'UTF-8'); } }
  $error   = $error   ?? ($_SESSION['flash_error']   ?? '');
  $success = $success ?? ($_SESSION['flash_success'] ?? '');
  unset($_SESSION['flash_error'], $_SESSION['flash_success']);
  $BASE = rtrim((string)(defined('BASE_URL') ? BASE_URL : ''), '/');
?>
<!doctype html>
<html lang="es" data-bs-theme="light">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title>Iniciar sesión — <?= h(defined('APP_NAME')?APP_NAME:'Sistema') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/@tabler/icons-webfont@3.21.0/tabler-icons.min.css" rel="stylesheet">
  <style>
    :root{
      --brand:#2b4862; --brand-500:#2b4862; --brand-600:#1f3a52; --ink:#0f172a;
      --line:#e5e7eb; --glass:rgba(255,255,255,.75);
      --shadow:0 18px 50px rgba(2,6,23,.18);
    }
    [data-bs-theme="dark"]{
      --glass:rgba(15,23,42,.75); --line:#1f2937; --ink:#e5e7eb;
      --shadow:0 18px 50px rgba(0,0,0,.55);
    }
    html, body { height:100%; }
    body{
      background:
        radial-gradient(1200px 800px at 10% 10%, #c7e1ff 0%, transparent 55%),
        radial-gradient(1000px 700px at 90% 20%, #c9fff1 0%, transparent 50%),
        radial-gradient(900px 600px at 30% 90%, #ffd4d4 0%, transparent 45%),
        linear-gradient(180deg, #f2f6fb, #eef4ff);
      display:flex; align-items:center; justify-content:center; padding:24px;
    }
    .auth-card{
      width:min(440px, 92vw);
      backdrop-filter: blur(10px) saturate(1.1);
      background:var(--glass);
      border:1px solid var(--line);
      border-radius:18px;
      box-shadow:var(--shadow);
    }
    .brand{
      width:56px; height:56px; border-radius:16px;
      background:linear-gradient(135deg, #9dd1ff, #2b86ff);
      display:flex; align-items:center; justify-content:center;
      color:#fff; font-size:1.6rem; box-shadow: inset 0 0 0 2px rgba(255,255,255,.25);
    }
    .form-control{
      border-radius:12px; padding:.7rem .9rem;
    }
    .btn-brand{
      background:linear-gradient(180deg, #2b86ff, #1f5bdc);
      border:none; color:#fff;
      border-radius:12px; padding:.75rem 1rem;
    }
    .btn-brand:hover{ filter:brightness(.96); }
    .muted{ color:#6b7280; }
    .link{ color:#2b86ff; text-decoration:none; }
    .link:hover{ text-decoration:underline; }
    .field-icon{
      position:absolute; right:12px; top:50%; transform:translateY(-50%);
      cursor:pointer; color:#94a3b8;
    }
  </style>
</head>
<body>

<main class="auth-card p-4 p-md-5">
  <!-- Encabezado -->
  <div class="d-flex align-items-center gap-3 mb-3">
    <div class="brand"><i class="ti ti-lock"></i></div>
    <div>
      <h1 class="h5 mb-1">Iniciar sesión</h1>
      <div class="muted small">Accede a <?= h(defined('APP_NAME')?APP_NAME:'el sistema') ?></div>
    </div>
  </div>

  <!-- Alertas -->
  <?php if (!empty($success)): ?>
    <div class="alert alert-success py-2"><?= h($success) ?></div>
  <?php endif; ?>
  <?php if (!empty($error)): ?>
    <div class="alert alert-danger py-2"><?= h($error) ?></div>
  <?php endif; ?>

  <!-- Formulario -->
  <form method="post" action="<?= h($BASE) ?>/auth/login" id="loginForm" novalidate>
    <?php if (!empty($_SESSION['csrf_token'])): ?>
      <input type="hidden" name="csrf_token" value="<?= h($_SESSION['csrf_token']) ?>">
    <?php endif; ?>

    <div class="mb-3">
      <label class="form-label">Correo</label>
      <input type="email" name="email" class="form-control" placeholder="tucorreo@dominio.com" required autofocus>
      <div class="invalid-feedback">Ingresa un correo válido.</div>
    </div>

    <div class="mb-2 position-relative">
      <label class="form-label d-flex align-items-center justify-content-between">
        <span>Contraseña</span>
        <a class="small link" href="<?= h($BASE) ?>/auth/forgot">¿Olvidaste tu contraseña?</a>
      </label>
      <input type="password" name="password" class="form-control" id="pwd" minlength="4" required>
      <i class="ti ti-eye field-icon" id="togglePwd" title="Mostrar/Ocultar"></i>
      <div class="invalid-feedback">Ingresa tu contraseña.</div>
    </div>

    <div class="d-flex align-items-center justify-content-between mb-3">
      <div class="form-check">
        <input class="form-check-input" type="checkbox" id="remember" name="remember" value="1">
        <label class="form-check-label" for="remember">Recordarme</label>
      </div>
      <!-- Placeholder para captcha si lo habilitas -->
      <!-- <span class="badge text-bg-light">reCAPTCHA</span> -->
    </div>

    <button class="btn btn-brand w-100 d-flex align-items-center justify-content-center gap-2" id="submitBtn">
      <span>Entrar</span>
      <span class="spinner-border spinner-border-sm d-none" id="btnSpinner" role="status" aria-hidden="true"></span>
    </button>

    <div class="text-center mt-3 muted small">
      ¿No tienes cuenta? <a href="<?= h($BASE) ?>/auth/register" class="link">Solicita acceso</a>
    </div>
  </form>
</main>

<!-- JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
  // Mostrar/Ocultar contraseña
  const pwd = document.getElementById('pwd');
  const toggle = document.getElementById('togglePwd');
  toggle?.addEventListener('click', () => {
    const t = pwd.getAttribute('type') === 'password' ? 'text' : 'password';
    pwd.setAttribute('type', t);
    toggle.className = (t === 'text') ? 'ti ti-eye-off field-icon' : 'ti ti-eye field-icon';
  });

  // Validación Bootstrap + spinner
  const form = document.getElementById('loginForm');
  const submitBtn = document.getElementById('submitBtn');
  const btnSpinner = document.getElementById('btnSpinner');
  form.addEventListener('submit', (e) => {
    if (!form.checkValidity()) {
      e.preventDefault(); e.stopPropagation();
    } else {
      submitBtn.setAttribute('disabled','disabled');
      btnSpinner.classList.remove('d-none');
    }
    form.classList.add('was-validated');
  });

  // Tema oscuro si el SO lo prefiere (opcional)
  if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
    document.documentElement.setAttribute('data-bs-theme','dark');
  }
</script>
</body>
</html>
