<?php require __DIR__ . '/../layout/header.php'; ?>

<h1 class="h5 mb-3 d-flex align-items-center gap-2">
  <i class="ti ti-badge-check"></i>
  Aprobar/Rechazar comisión
  <span class="text-secondary">(Presidente COMGA)</span>
</h1>

<?php
  // ====== Resumen de importes ======
  $costoCombustible = 0.00;
  if (!empty($movilidad) && !empty($movilidad['combustible'])) {
    $comb = $movilidad['combustible'];
    $costoCombustible = (float)($comb['costo_usd'] ?? ($comb['costo'] ?? 0));
  }
  $totalViaticos = (float)($viaticos['total_global'] ?? 0);
  $totalGeneral  = $totalViaticos + $costoCombustible;

  // ====== Integrantes: unificar chips + sistema, SIN duplicados ======
  $rawChips = array_filter(array_map('trim', explode(',', (string)($item['participantes_text'] ?? ''))));

  $tablaIntegrantes = [];   // solo nombres
  $seen = [];

  // desde chips escritos
  foreach ($rawChips as $n) {
    if ($n==='') continue;
    $k = mb_strtolower($n);
    if (isset($seen[$k])) continue;
    $seen[$k] = true;
    $tablaIntegrantes[] = ['nombre'=>$n];
  }

  // desde sistema (si viene)
  if (!empty($participantesSistema)) {
    foreach ($participantesSistema as $ps) {
      $n = trim((string)($ps['nombre'] ?? ''));
      if ($n==='') continue;
      $k = mb_strtolower($n);
      if (isset($seen[$k])) continue;
      $seen[$k] = true;
      $tablaIntegrantes[] = ['nombre'=>$n];
    }
  }

  // ordenar alfabéticamente por nombre
  usort($tablaIntegrantes, fn($a,$b)=>strcoll($a['nombre'],$b['nombre']));
?>

<style>
  .card-soft { border:1px solid #e6eaf0; border-radius:14px; background:#fff; }
  .file-box { border:1px dashed #c7d2fe; border-radius:12px; padding:16px; background:#f8faff; }
  .file-box i { font-size:1.8rem; color:#4263eb; }
  .table-modern thead th { background:#f6f8fc; font-weight:600; }
  .table-modern tbody tr:hover { background:#fafcff; }
</style>

<!-- RESUMEN DE COSTOS -->
<div class="card-soft p-3 mb-3 shadow-sm">
  <div class="d-flex align-items-center justify-content-between flex-wrap gap-2 mb-2">
    <div class="fw-semibold d-flex align-items-center gap-2">
      <i class="ti ti-report-money"></i> Resumen de costos de la comisión
    </div>
    <div class="text-secondary small">
      * Suma informativa: viáticos + combustible
    </div>
  </div>

  <div class="row g-2">
    <div class="col-12 col-md-4">
      <div class="border rounded-3 p-3 h-100 bg-light">
        <div class="d-flex align-items-center justify-content-between">
          <div class="fw-semibold"><i class="ti ti-cash me-1"></i> Viáticos</div>
          <span class="badge text-bg-secondary"><?= h($viaticos['dias'] ?? 0) ?> día(s)</span>
        </div>
        <div class="display-6" style="font-size:1.6rem;">
          $<?= number_format($totalViaticos, 2) ?>
        </div>
        <div class="small text-secondary">Fórmula: <?= h($viaticos['formula'] ?? '') ?></div>
      </div>
    </div>
    <div class="col-12 col-md-4">
      <div class="border rounded-3 p-3 h-100 bg-light">
        <div class="fw-semibold"><i class="ti ti-gas-station me-1"></i> Combustible</div>
        <div class="display-6" style="font-size:1.6rem;">
          $<?= number_format($costoCombustible, 2) ?>
        </div>
        <div class="small text-secondary">Incluye estimación según rendimiento y precio</div>
      </div>
    </div>
    <div class="col-12 col-md-4">
      <div class="border rounded-3 p-3 h-100 bg-light">
        <div class="fw-semibold"><i class="ti ti-sum me-1"></i> TOTAL GENERAL</div>
        <div class="display-6 fw-bold" style="font-size:1.8rem;">
          $<?= number_format($totalGeneral, 2) ?>
        </div>
        <div class="small text-secondary">Viáticos + Combustible</div>
      </div>
    </div>
  </div>
</div>

<!-- ENCABEZADO + INTEGRANTES + ADJUNTO -->
<div class="card-soft p-3 mb-3 shadow-sm">
  <div class="row g-3">
    <!-- Columna izquierda: textos + tabla integrantes -->
    <div class="col-lg-8">
      <div class="d-flex align-items-center gap-2 mb-1">
        <i class="ti ti-file-description text-secondary"></i>
        <span class="fw-semibold">Título:</span>
        <span><?= h($item['titulo']) ?></span>
      </div>

      <div class="d-flex align-items-center gap-2 mb-1">
        <i class="ti ti-calendar text-secondary"></i>
        <span class="fw-semibold">Rango:</span>
        <span><?= h($item['fecha_inicio']) ?> → <?= h($item['fecha_fin']) ?></span>
      </div>

      <div class="d-flex align-items-start gap-2">
        <i class="ti ti-notes text-secondary mt-1"></i>
        <div>
          <div class="fw-semibold">Descripción:</div>
          <div><?= nl2br(h($item['descripcion'])) ?></div>
        </div>
      </div>

      <!-- Integrantes (tabla simplificada: solo nombres) -->
      <div class="mt-3">
        <div class="fw-semibold mb-2"><i class="ti ti-users"></i> Integrantes de la comisión</div>

        <?php if (empty($tablaIntegrantes)): ?>
          <div class="text-secondary small">Sin integrantes registrados.</div>
        <?php else: ?>
          <div class="table-responsive">
            <table class="table table-sm align-middle table-modern">
              <thead>
                <tr>
                  <th style="width:48px" class="text-center">#</th>
                  <th><i class="ti ti-user"></i> Funcionario COMGA</th>
                </tr>
              </thead>
              <tbody>
                <?php $i=1; foreach ($tablaIntegrantes as $p): ?>
                  <tr>
                    <td class="text-center"><?= $i++ ?></td>
                    <td class="fw-semibold"><?= h($p['nombre']) ?></td>
                  </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        <?php endif; ?>
      </div>
    </div>

    <!-- Columna derecha: adjunto centrado -->
    <div class="col-lg-4">
      <div class="fw-semibold mb-2 text-center"><i class="ti ti-paperclip"></i> Documento de planificación</div>
      <div class="file-box text-center">
        <div class="mb-2"><i class="ti ti-file-text"></i></div>

        <?php if (!empty($item['plan_nombre'])): ?>
          <div class="small text-truncate mb-2" title="<?= h($item['plan_nombre']) ?>">
            <?= h($item['plan_nombre']) ?>
          </div>
        <?php endif; ?>

        <?php if (!empty($item['plan_ruta'])): ?>
          <div class="d-grid">
            <a class="btn btn-outline-primary btn-sm" href="<?= h($item['plan_ruta']) ?>" target="_blank" rel="noopener">
              <i class="ti ti-eye"></i> Ver adjunto
            </a>
          </div>
        <?php else: ?>
          <div class="text-secondary small">No se adjuntó planificación.</div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>

<!-- TRASLADO + COMBUSTIBLE -->
<?php if (!empty($movilidad)): $comb = $movilidad['combustible']; ?>
<div class="card-soft p-3 mb-3 shadow-sm">
  <div class="d-flex align-items-center gap-2 mb-2">
    <i class="ti ti-road"></i>
    <div class="fw-semibold">Traslado y combustible</div>
  </div>

  <div class="row g-3">
    <div class="col-md-6">
      <div class="d-flex align-items-center gap-2 mb-1">
        <i class="ti ti-map-pin text-secondary"></i>
        <span><b>Origen:</b> <?= h($movilidad['origen'] ?: '—') ?></span>
      </div>
      <div class="d-flex align-items-center gap-2 mb-1">
        <i class="ti ti-arrow-right text-secondary"></i>
        <span><b>Destino (ida):</b> <?= h($movilidad['destino'] ?: '—') ?></span>
      </div>
      <div class="d-flex align-items-center gap-2 mb-2">
        <i class="ti ti-arrow-back-up text-secondary"></i>
        <span><b>Destino (retorno):</b> <?= h($movilidad['retorno'] ?: '—') ?></span>
      </div>

      <div class="d-flex align-items-center gap-2 mb-1">
        <i class="ti ti-steering-wheel text-secondary"></i>
        <span><b>Vehículo:</b> <?= h($movilidad['vehiculo'] ?: '—') ?></span>
      </div>
      <div class="d-flex align-items-center gap-2">
        <i class="ti ti-id text-secondary"></i>
        <span><b>Chofer:</b> <?= h($movilidad['chofer'] ?: '—') ?></span>
      </div>
    </div>

    <div class="col-md-6">
      <div class="border rounded p-2 bg-light">
        <div class="d-flex justify-content-between small">
          <div><b>Kilómetros totales</b></div>
          <div><?= number_format((float)$movilidad['km_totales'], 2) ?> km</div>
        </div>
        <div class="d-flex justify-content-between small">
          <div><b>Tipo de combustible</b></div>
          <div><?= h($comb['tipo'] ?? '—') ?></div>
        </div>
        <?php if (isset($comb['km_por_galon'])): ?>
          <div class="d-flex justify-content-between small">
            <div><b>Rendimiento</b></div>
            <div>~ <?= number_format($comb['km_por_galon'], 1) ?> km/gal</div>
          </div>
          <div class="d-flex justify-content-between small">
            <div><b>Consumo estimado</b></div>
            <div><?= number_format($comb['galones'], 2) ?> gal</div>
          </div>
          <div class="d-flex justify-content-between small">
            <div><b>Precio por galón</b></div>
            <div>$<?= number_format($comb['precio_galon'], 2) ?></div>
          </div>
          <hr class="my-2">
          <div class="d-flex justify-content-between">
            <div class="fw-semibold"><i class="ti ti-gas-station"></i> Costo combustible</div>
            <div class="fw-bold">$<?= number_format($comb['costo_usd'], 2) ?></div>
          </div>
        <?php else: ?>
          <div class="d-flex justify-content-between small">
            <div><b>Rendimiento</b></div>
            <div>~ <?= number_format($comb['km_por_litro'] ?? 0, 1) ?> km/L</div>
          </div>
          <div class="d-flex justify-content-between small">
            <div><b>Consumo estimado</b></div>
            <div><?= number_format($comb['litros'] ?? 0, 2) ?> L</div>
          </div>
          <div class="d-flex justify-content-between small">
            <div><b>Precio por litro</b></div>
            <div>$<?= number_format($comb['precio_litro'] ?? 0, 2) ?></div>
          </div>
          <hr class="my-2">
          <div class="d-flex justify-content-between">
            <div class="fw-semibold"><i class="ti ti-gas-station"></i> Costo combustible</div>
            <div class="fw-bold">$<?= number_format($comb['costo_usd'] ?? 0, 2) ?></div>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>
<?php endif; ?>

<!-- VIÁTICOS -->
<div class="card-soft p-3 mb-3 shadow-sm">
  <div class="d-flex justify-content-between align-items-center mb-2">
    <div class="fw-semibold d-flex align-items-center gap-2">
      <i class="ti ti-cash"></i> Viáticos estimados
    </div>
    <div class="text-secondary small">
      Cálculo: <?= h($viaticos['formula']) ?> (por persona)
    </div>
  </div>

  <div class="table-responsive">
    <table class="table table-sm align-middle table-modern">
      <thead class="table-light">
        <tr>
          <th><i class="ti ti-user"></i> Participante</th>
          <th class="text-center"><i class="ti ti-calendar"></i> Días</th>
          <th class="text-end"><i class="ti ti-currency-dollar"></i> Monto (USD)</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($viaticos['detalles'] as $row): ?>
          <tr>
            <td><?= h($row['nombre']) ?></td>
            <td class="text-center"><?= (int)$row['dias'] ?></td>
            <td class="text-end"><?= number_format($row['monto'], 2) ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
      <tfoot>
        <tr>
          <th colspan="2" class="text-end">Total estimado</th>
          <th class="text-end"><?= number_format($totalViaticos, 2) ?></th>
        </tr>
      </tfoot>
    </table>
  </div>

  <div class="small text-secondary">
    * Solo informativo para aprobación; no afecta contabilidad.
  </div>
</div>

<!-- FORM APROBAR / RECHAZAR -->
<form method="post" class="card-soft p-3 shadow-sm">
  <div class="mb-2 fw-semibold d-flex align-items-center gap-2">
    <i class="ti ti-message-dots"></i> Comentario del Presidente COMGA
  </div>
  <textarea name="comentario" class="form-control mb-3" rows="4" placeholder="Opcional: justificación o instrucciones…"></textarea>

  <div class="d-flex flex-wrap gap-2">
    <button name="estado" value="APROBADA" class="btn btn-success">
      <i class="ti ti-check"></i> Aprobar
    </button>
    <button name="estado" value="RECHAZADA" class="btn btn-danger">
      <i class="ti ti-x"></i> Rechazar
    </button>
    <a class="btn btn-light ms-auto" href="<?= h(BASE_URL) ?>/comision/index">
      <i class="ti ti-arrow-back-up"></i> Cancelar
    </a>
  </div>
</form>

<?php require __DIR__ . '/../layout/footer.php'; ?>
