<?php require __DIR__ . '/../layout/header.php'; ?>

<h1 class="h5 mb-3 d-flex align-items-center gap-2">
  <i class="ti ti-file-certificate"></i>
  Constancia de Aprobación
  <span class="text-secondary">(Presidente COMGA)</span>
</h1>

<style>
  .card-soft{border:1px solid #e6eaf0;border-radius:14px;background:#fff;}
  .pill{display:inline-flex;align-items:center;gap:.4rem;padding:.25rem .55rem;border-radius:999px;font-size:.78rem;background:#f2f5fb;border:1px solid #e5eaf4;color:#475569;}
  .sig-wrap{display:flex;gap:24px;flex-wrap:wrap;margin-top:8px}
  .sig{flex:1 1 320px;text-align:center;margin-top:22px}
  .sig .line{border-top:2px solid #1f2937;margin:20px auto 6px;max-width:360px}
  .muted{color:#64748b}
  .doc-frame{width:100%;height:560px;border:0}
</style>

<?php
  // Datos base
  $codigo        = (string)$const['codigo'];
  $verifUrl      = BASE_URL . '/constancia/verificar/' . urlencode($codigo);
  $url           = (string)$const['pdf_path'];
  $isPdf         = str_ends_with(strtolower($url), '.pdf');
  $estadoConst   = strtoupper($const['estado'] ?? 'GENERADA');
  $badge         = $estadoConst === 'FIRMADA' ? 'success' : ($estadoConst === 'ANULADA' ? 'danger' : 'warning');

  // Por si tenemos datos de movilidad para recordar lo del combustible/chofer
  $chofer = '';
  if (!empty($movilidad) && !empty($movilidad['chofer'])) {
    $chofer = trim((string)$movilidad['chofer']);
  }
?>

<div class="card-soft p-3 shadow-sm mb-3">
  <div class="row g-3">
    <div class="col-lg-8">
      <!-- Cabecera y acciones -->
      <div class="d-flex flex-wrap align-items-center gap-3 mb-2">
        <div><span class="fw-semibold">Código:</span> <?= h($codigo) ?></div>
        <div class="text-secondary">
          <span class="fw-semibold">Verificación:</span>
          <a target="_blank" href="<?= h($verifUrl) ?>"><?= h($verifUrl) ?></a>
        </div>
        <span class="badge bg-<?= $badge ?>">Constancia <?= h($estadoConst) ?></span>
      </div>

      <!-- Visor del documento -->
      <div class="border rounded p-2 bg-light">
        <?php if ($isPdf): ?>
          <iframe src="<?= h($url) ?>" class="doc-frame" title="Constancia PDF"></iframe>
        <?php else: ?>
          <div class="alert alert-info py-2 mb-2">
            La constancia fue generada en HTML.
            <a class="alert-link" target="_blank" href="<?= h($url) ?>">Abrir en nueva pestaña</a>
          </div>
          <iframe src="<?= h($url) ?>" class="doc-frame" title="Constancia HTML"></iframe>
        <?php endif; ?>
      </div>

      <!-- Declaración de validez + firma única -->
      <div class="card-soft p-3 mt-3">
        <div class="fw-semibold mb-1"><i class="ti ti-certificate"></i> Declaración de validez</div>
        <div class="muted">
          Esta constancia se considera legítima si su código y URL de verificación
          coinciden con los emitidos por el Sistema de Gestión de Comisiones del
          <b>COMAGA</b>. La verificación pública permite a terceros confirmar su
          existencia y estado.
        </div>

        <div class="sig-wrap">
          <div class="sig">
            <div class="line"></div>
            <div class="fw-semibold">Presidente COMGA</div>
          </div>
        </div>
      </div>

      <!-- Acciones -->
      <div class="mt-3 d-flex gap-2 flex-wrap">
        <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?= h($url) ?>">
          <i class="ti ti-download"></i> Descargar
        </a>
        <a class="btn btn-sm btn-outline-dark" target="_blank" href="<?= h($verifUrl) ?>">
          <i class="ti ti-qrcode"></i> Verificar en línea
        </a>
        <a class="btn btn-sm btn-outline-secondary" href="<?= h(BASE_URL) ?>/comision/index">
          <i class="ti ti-arrow-back-up"></i> Volver
        </a>
      </div>
    </div>

    <div class="col-lg-4">
      <?php if (!empty($chofer)): ?>
        <div class="card-soft p-3 mb-3">
          <div class="fw-semibold mb-1"><i class="ti ti-gas-station"></i> Fondo de combustible</div>
          <div class="small">
            El fondo de combustible se asigna al chofer responsable:
            <b><?= h($chofer) ?></b>.
          </div>
        </div>
      <?php endif; ?>

      <?php if (!empty($const['firmado_path'])): ?>
        <div class="card-soft p-3 mb-3">
          <div class="fw-semibold mb-2"><i class="ti ti-file-check"></i> Documento firmado</div>
          <a class="btn btn-sm btn-success w-100" target="_blank" href="<?= h($const['firmado_path']) ?>">
            <i class="ti ti-download"></i> Descargar firmado
          </a>
          <div class="small text-success mt-2">
            <i class="ti ti-badge-check"></i> Firma registrada
          </div>
        </div>
      <?php endif; ?>

      <?php if (!empty($esAlcalde) && $esAlcalde): // permiso para subir firmado ?>
        <div class="card-soft p-3">
          <div class="fw-semibold mb-2">
            <i class="ti ti-signature"></i> Subir PDF firmado (Presidente COMGA)
          </div>
          <form method="post" enctype="multipart/form-data">
            <input type="file" name="pdf_firmado" accept="application/pdf" class="form-control mb-2" required>
            <button class="btn btn-success w-100"><i class="ti ti-upload"></i> Guardar firmado</button>
          </form>
          <div class="small text-secondary mt-2">
            * Firma electrónicamente con tu herramienta habitual y luego sube el PDF.
          </div>
        </div>
      <?php else: ?>
        <?php if (empty($const['firmado_path'])): ?>
          <div class="alert alert-info">
            Aún no se ha subido el PDF firmado por el <b>Presidente COMGA</b>.
          </div>
        <?php endif; ?>
      <?php endif; ?>
    </div>
  </div>
</div>

<?php require __DIR__ . '/../layout/footer.php'; ?>
