<?php require __DIR__ . '/../layout/header.php'; ?>
<h1 class="h5 mb-3"><i class="ti ti-car"></i> Nueva comisión</h1>
<?php
$old = function(string $key, string $default = ''){ return isset($_POST[$key]) ? trim((string)$_POST[$key]) : $default; };
$oldArea   = isset($_POST['area_id']) ? (string)$_POST['area_id'] : '';
$oldDept   = isset($_POST['department_id']) ? (string)$_POST['department_id'] : '';
$oldPart   = $old('participantes_text');
$oldChofer = $old('chofer_nombre');
$oldVehic  = $old('vehiculo_nombre');
$oldOrigen  = $old('origen_ciudad');
$oldDestIda = $old('destino_ida_ciudad');
$oldDestRet = $old('destino_retorno_ciudad');
$oldKm      = $old('total_km');

$CHOFERES  = ['DAVID MUÑOZ','LUIS RODRIGUEZ','GERARDO'];
$VEHICULOS = ['TOYOTA FORTUNER','TOYOTA HILUX','CHEVROLET D-MAX','VITARA 3 PUERTAS'];

/* === Catálogo de funcionarios para autocompletar === */
$FUNCIONARIOS = [
  'SAMANTHA MABEL MONTOYA GALLEGOS','ROSANA LUGO','JESSYCA FERNANDEZ','CONSUELO LOPOZ',
  'AGEL GUALLI','MARIA LORENA BRITO','KEVIN DURAN','MARITZA ALQUING','LADY ALQUIGA',
  'MISHEL BURGOS','MICHELLE PAZ'
];

$FUEL_GAS_PRICE    = defined('FUEL_GAS_PRICE_USD')    ? (float)FUEL_GAS_PRICE_USD    : 2.88;
$FUEL_DIESEL_PRICE = defined('FUEL_DIESEL_PRICE_USD') ? (float)FUEL_DIESEL_PRICE_USD : 2.80;
?>
<?php if (!empty($error)): ?>
  <div class="alert alert-danger py-2"><?= h($error) ?></div>
<?php endif; ?>

<style>
  .chip button { line-height: 1; }
  .resumen-box{ border:1px solid var(--line-soft,#e9edf3); border-radius:14px; background:linear-gradient(180deg,#ffffff,#fbfcfe); }
  .resumen-item{ display:flex; align-items:center; justify-content:space-between; gap:.75rem; padding:.65rem .75rem; border-radius:12px; border:1px dashed rgba(2,6,23,.08); background:#fff; }
  .resumen-total{ background:#0d6efd0f; border:1px solid #cfe2ff; border-radius:12px; padding:.9rem .95rem; }
  .badge-soft{ background:#eef2ff; color:#2b4862; border:1px solid #dbe4ff; }
  .table-mini th,.table-mini td{ padding:.35rem .5rem; }
  .is-chofer{ background:#e6fffb; border:1px solid #b2f5ea; }
  @media (max-width:575.98px){ .resumen-grid{ grid-template-columns:1fr !important; } }
</style>

<form method="post" class="card p-3 shadow-sm" enctype="multipart/form-data" id="form-comision">
  <div class="row g-3">
    <div class="col-md-8">
      <label class="form-label">Título</label>
      <input name="titulo" class="form-control" required value="<?= h($old('titulo')) ?>">
    </div>
    <div class="col-md-4">
      <label class="form-label">Área</label>
      <select name="area_id" id="area_id" class="form-select">
        <option value="">(Ninguna)</option>
        <?php foreach($areas as $a): ?>
          <option value="<?= (int)$a['id'] ?>" <?= $oldArea==(string)$a['id']?'selected':'' ?>><?= h($a['nombre']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="col-md-4">
      <label class="form-label">Departamento</label>
      <select name="department_id" id="department_id" class="form-select">
        <option value="">(Ninguno)</option>
      </select>
    </div>
    <div class="col-md-4">
      <label class="form-label">Fecha inicio</label>
      <input type="date" name="fecha_inicio" class="form-control" required value="<?= h($old('fecha_inicio')) ?>">
    </div>
    <div class="col-md-4">
      <label class="form-label">Fecha fin</label>
      <input type="date" name="fecha_fin" class="form-control" required value="<?= h($old('fecha_fin')) ?>">
    </div>

    <div class="col-12">
      <label class="form-label">Descripción</label>
      <textarea name="descripcion" class="form-control" rows="3"><?= h($old('descripcion')) ?></textarea>
    </div>

    <!-- Chofer y Vehículo -->
    <div class="col-md-6">
      <label class="form-label">Chofer</label>
      <select name="chofer_nombre" id="chofer_nombre" class="form-select">
        <option value="">(Sin chofer)</option>
        <?php foreach($CHOFERES as $ch): ?>
          <option value="<?= h($ch) ?>" <?= $oldChofer===$ch?'selected':'' ?>><?= h($ch) ?></option>
        <?php endforeach; ?>
      </select>
      <div class="form-text">El chofer también recibe viáticos y se le deposita el fondo de combustible.</div>
    </div>
    <div class="col-md-6">
      <label class="form-label">Vehículo</label>
      <select name="vehiculo_nombre" id="vehiculo_nombre" class="form-select">
        <option value="">(Sin vehículo)</option>
        <?php foreach($VEHICULOS as $vh): ?>
          <option value="<?= h($vh) ?>" <?= $oldVehic===$vh?'selected':'' ?>><?= h($vh) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <!-- Traslado -->
    <div class="col-md-4">
      <label class="form-label">Origen</label>
      <input name="origen_ciudad" id="origen_ciudad" class="form-control" value="<?= h($oldOrigen) ?>">
    </div>
    <div class="col-md-4">
      <label class="form-label">Destino (ida)</label>
      <input name="destino_ida_ciudad" id="destino_ida_ciudad" class="form-control" value="<?= h($oldDestIda) ?>">
    </div>
    <div class="col-md-4">
      <label class="form-label">Destino (retorno)</label>
      <input name="destino_retorno_ciudad" id="destino_retorno_ciudad" class="form-control" value="<?= h($oldDestRet) ?>">
    </div>
    <div class="col-md-4">
      <label class="form-label">Kilómetros totales (ida + retorno)</label>
      <input name="total_km" id="total_km" type="number" step="0.01" min="0" class="form-control" placeholder="Ej.: 320" value="<?= h($oldKm) ?>">
      <div class="form-text">Se usa para estimar el fondo de combustible del chofer.</div>
    </div>

    <!-- Participantes con autocompletar -->
    <div class="col-12">
      <label class="form-label">Funcionarios que forma parte de la Comision (escribe y Enter)</label>
      <div id="chipbox" class="form-control d-flex flex-wrap gap-2 align-items-center" style="min-height:48px">
        <input id="chipInput" type="text" class="border-0 flex-grow-1" placeholder="Ej.: Juan Pérez" style="outline:none;" list="funcList">
      </div>
      <datalist id="funcList">
        <?php foreach($FUNCIONARIOS as $f): ?>
          <option value="<?= h($f) ?>"></option>
        <?php endforeach; ?>
      </datalist>
      <input type="hidden" name="participantes_text" id="participantes_text" value="<?= h($oldPart) ?>">
      <div class="form-text">Sugerencias incluidas. Puedes escribir otros nombres también.</div>

      <!-- Tabla mini de participantes -->
      <div class="table-responsive mt-2">
        <table class="table table-mini table-bordered align-middle mb-0" id="tabla-participantes">
          <thead class="table-light"><tr><th style="width:36px"></th><th>Funcionarios parte de la Comision</th><th style="width:120px" class="text-center">¿Chofer?</th></tr></thead>
          <tbody></tbody>
        </table>
      </div>
    </div>

    <!-- Adjunto -->
    <div class="col-md-6">
      <label class="form-label">Documento de planificación / solicitud</label>
      <input type="hidden" name="MAX_FILE_SIZE" value="<?= 16 * 1024 * 1024 ?>">
      <input type="file" name="planificacion" id="planificacion" class="form-control" accept=".pdf,.doc,.docx,.xlsx,.jpg,.jpeg,.png">
    </div>

    <!-- PREVIEW -->
    <div class="col-12">
      <div class="card p-3 mt-1 resumen-box">
        <div class="d-flex align-items-center justify-content-between mb-2">
          <div class="fw-semibold">
            <i class="ti ti-cash"></i> Resumen estimado (viáticos y fondo de combustible)
          </div>
          <span class="badge rounded-pill badge-soft">Estimado</span>
        </div>

        <div id="viaticosPreview" class="small text-secondary">
          Ingresa fechas, participantes, chofer/vehículo y KM para ver el cálculo.
        </div>

        <div class="mt-3">
          <div class="resumen-grid d-grid" style="grid-template-columns: repeat(3,1fr); gap:.75rem;">
            <div class="resumen-item"><span class="label"><i class="ti ti-users"></i> Total Viáticos</span><span class="value h6 mb-0" id="totalViaticosView">$0.00</span></div>
            <div class="resumen-item"><span class="label"><i class="ti ti-gas-station"></i> Fondo de Combustible (chofer)</span><span class="value h6 mb-0" id="totalCombustibleView">$0.00</span></div>
            <div class="resumen-total d-flex align-items-center justify-content-between"><span class="label"><i class="ti ti-sum"></i> TOTAL GENERAL</span><span class="value h5 mb-0 text-brand" id="granTotalView">$0.00</span></div>
          </div>
          <div class="form-text mt-2">El fondo de combustible se deposita al chofer (además de su viático).</div>
        </div>
      </div>
    </div>
  </div>

  <div class="mt-3 d-flex gap-2">
    <a class="btn btn-light" href="<?= h(BASE_URL) ?>/comision/index">Cancelar</a>
    <button class="btn btn-primary" id="btn-submit">Guardar</button>
  </div>
</form>

<script>
/* ===== dependientes ===== */
async function cargarDepartamentos(areaId, pre){ const sel=document.getElementById('department_id'); sel.innerHTML='<option value="">(Ninguno)</option>'; if(!areaId) return;
  try{ const resp=await fetch('<?= h(BASE_URL) ?>/departamento/byArea/'+areaId); const items=await resp.json();
    items.forEach(i=>{ const o=document.createElement('option'); o.value=i.id; o.textContent=i.nombre; if(String(pre||'')===String(i.id)) o.selected=true; sel.appendChild(o); });
  }catch(e){}
}
const areaSel=document.getElementById('area_id'); areaSel.addEventListener('change',()=>cargarDepartamentos(areaSel.value,''));

/* ===== chips + tabla ===== */
const chipBox=document.getElementById('chipbox'); const chipInput=document.getElementById('chipInput'); const hidden=document.getElementById('participantes_text');
let chips=[];

function renderChips(){
  [...chipBox.querySelectorAll('.chip')].forEach(n=>n.remove());
  chips.forEach((txt,idx)=>{
    const s=document.createElement('span'); s.className='chip badge rounded-pill bg-secondary d-inline-flex align-items-center'; s.style.padding='.5rem .7rem';
    s.innerHTML=`<span>${txt}</span><button type="button" class="btn btn-sm btn-link text-white ms-2 p-0" data-idx="${idx}" aria-label="Eliminar"><i class="ti ti-x"></i></button>`;
    chipBox.insertBefore(s,chipInput);
  });
  hidden.value = chips.join(', ');
  renderTabla();
}

function renderTabla(){
  const tb=document.querySelector('#tabla-participantes tbody'); tb.innerHTML='';
  const ch=(document.getElementById('chofer_nombre').value||'').trim().toLowerCase();
  chips.forEach((n,i)=>{
    const tr=document.createElement('tr');
    const isChofer=(n.trim().toLowerCase()===ch);
    if(isChofer) tr.classList.add('is-chofer');
    tr.innerHTML=`<td class="text-center"><button class="btn btn-sm btn-outline-danger" type="button" data-rm="${i}"><i class="ti ti-trash"></i></button></td>
                  <td>${n}</td><td class="text-center">${isChofer ? '<span class="badge bg-info">Chofer</span>' : '—'}</td>`;
    tb.appendChild(tr);
  });
}

chipBox.addEventListener('click',()=>chipInput.focus());
chipBox.addEventListener('click',(e)=>{ const b=e.target.closest('button[data-idx]'); if(!b) return; chips.splice(parseInt(b.getAttribute('data-idx'),10),1); renderChips(); calcPreview(); });
document.querySelector('#tabla-participantes').addEventListener('click',(e)=>{ const b=e.target.closest('button[data-rm]'); if(!b) return; chips.splice(parseInt(b.getAttribute('data-rm'),10),1); renderChips(); calcPreview(); });

chipInput.addEventListener('keydown',(e)=>{
  if(e.key==='Enter'){ e.preventDefault(); const val=chipInput.value.trim(); if(val){ chips.push(val); chipInput.value=''; renderChips(); calcPreview(); } }
});
document.getElementById('chofer_nombre').addEventListener('change',()=>{ renderTabla(); calcPreview(); });

/* ===== sticky inicial ===== */
document.addEventListener('DOMContentLoaded',()=>{
  const preArea='<?= h($oldArea) ?>'; const preDept='<?= h($oldDept) ?>'; if(preArea) cargarDepartamentos(preArea,preDept);
  const ini=hidden.value.trim(); if(ini){ chips=ini.split(',').map(s=>s.trim()).filter(Boolean); renderChips(); }
  calcPreview();
});

/* ===== validación ===== */
document.getElementById('form-comision').addEventListener('submit',(e)=>{
  const i=document.querySelector('input[name="fecha_inicio"]').value; const f=document.querySelector('input[name="fecha_fin"]').value;
  if(i && f && i>f){ e.preventDefault(); alert('La fecha de fin debe ser igual o posterior a inicio.'); return; }
  const file=document.getElementById('planificacion'); if(file.files && file.files.length){ const size=file.files[0].size||0; if(size>16*1024*1024){ e.preventDefault(); alert('Archivo supera 16 MB'); return; } }
});

/* ===== preview cálculos ===== */
function parseFecha(v){ if(!v) return null; const d=new Date(v+'T00:00:00'); return isNaN(d)?null:d; }
function diffDiasIncl(a,b){ if(!a||!b) return 0; return Math.floor((b-a)/(1000*60*60*24))+1; }
function num(v){ const n=parseFloat(v); return isNaN(n)?0:n; }
function fmtUSD(n){ try{ return n.toLocaleString('es-EC',{style:'currency',currency:'USD',minimumFractionDigits:2}); }catch(_){ return '$'+(+n).toFixed(2); } }

const MAPA_VEHICULOS={'TOYOTA FORTUNER':{tipo:'GASOLINA',kmGal:22.0},'TOYOTA HILUX':{tipo:'GASOLINA',kmGal:36.0},'CHEVROLET D-MAX':{tipo:'DIÉSEL',kmGal:38.0},'VITARA 3 PUERTAS':{tipo:'GASOLINA',kmGal:50.0}};
const PRECIO_GAS=<?= json_encode($FUEL_GAS_PRICE) ?>, PRECIO_DIESEL=<?= json_encode($FUEL_DIESEL_PRICE) ?>, L=3.785411784;

function calcCombustible(){
  const vh=(document.getElementById('vehiculo_nombre')?.value||'').trim().toUpperCase();
  const km=num(document.getElementById('total_km')?.value||'0');
  const conf=MAPA_VEHICULOS[vh]||{tipo:'GASOLINA',kmGal:30.0}; const gal=km>0?(km/conf.kmGal):0; const precioGal=(conf.tipo==='DIÉSEL')?PRECIO_DIESEL:PRECIO_GAS; const costo=gal*precioGal;
  return {km,tipo:conf.tipo,kmGal:conf.kmGal,galones:gal,litros:gal*L,precioGal,costo};
}
function participantesPreview(){
  const arr=[...chips]; const ch=(document.getElementById('chofer_nombre').value||'').trim(); if(ch) arr.push(ch);
  const seen={}; return arr.filter(n=>{ const k=n.toLowerCase(); if(seen[k]) return false; seen[k]=true; return true; });
}
function calcPreview(){
  const cont=document.getElementById('viaticosPreview');
  const ini=parseFecha(document.querySelector('input[name="fecha_inicio"]').value);
  const fin=parseFecha(document.querySelector('input[name="fecha_fin"]').value);
  const dias=diffDiasIncl(ini,fin);
  const lista=participantesPreview();
  const ch=(document.getElementById('chofer_nombre').value||'').trim();
  const vh=(document.getElementById('vehiculo_nombre').value||'').trim();
  const comb=calcCombustible();

  // viáticos
  let totalVia=0, rows='';
  if(dias && lista.length){
    lista.forEach(n=>{ const m=(dias<=1)?40:(80*dias); totalVia+=m; rows+=`<tr><td>${n}</td><td class="text-center">${dias}</td><td class="text-end">${m.toFixed(2)}</td></tr>`; });
  }

  const infoMov = `
    <div class="mb-2">
      <b>Chofer:</b> ${ch||'—'} &nbsp; | &nbsp; <b>Vehículo:</b> ${vh||'—'}<br>
      KM totales: <b>${comb.km.toFixed(2)} km</b> · Comb.: <b>${comb.galones.toFixed(2)} gal</b> × ${fmtUSD(comb.precioGal)}/gal
      (rend. ~ ${comb.kmGal.toFixed(1)} km/gal) = <b>${fmtUSD(comb.costo)}</b>
    </div>
    <div class="alert alert-info py-2">Al chofer se le deposita <b>viático + fondo de combustible</b>.</div>
  `;

  const tabla = (dias && lista.length) ? `
    <div class="mb-2">Días: <b>${dias}</b> — Fórmula: <b>${dias<=1?'1 día × USD 40':(dias+' días × USD 80')}</b> (por persona)</div>
    <div class="table-responsive">
      <table class="table table-sm mb-0 align-middle">
        <thead class="table-light"><tr><th>Participante</th><th class="text-center">Días</th><th class="text-end">Viático (USD)</th></tr></thead>
        <tbody>${rows}</tbody>
        <tfoot><tr><th colspan="2" class="text-end">Total viáticos</th><th class="text-end">${totalVia.toFixed(2)}</th></tr></tfoot>
      </table>
    </div>` : 'Completa fechas y participantes para ver viáticos.';

  cont.innerHTML = infoMov + tabla;

  document.getElementById('totalViaticosView').textContent   = fmtUSD(totalVia);
  document.getElementById('totalCombustibleView').textContent = fmtUSD(comb.costo||0);
  document.getElementById('granTotalView').textContent        = fmtUSD((comb.costo||0)+totalVia);
}

['fecha_inicio','fecha_fin','chofer_nombre','vehiculo_nombre','origen_ciudad','destino_ida_ciudad','destino_retorno_ciudad','total_km']
  .forEach(id=>{ const n=document.getElementById(id); if(n) n.addEventListener('input',calcPreview); });
</script>

<?php require __DIR__ . '/../layout/footer.php'; ?>
