<?php require __DIR__ . '/../layout/header.php'; ?>

<div class="d-flex align-items-center justify-content-between mb-3">
  <h1 class="h5 mb-0"><i class="ti ti-plane"></i> Comisiones</h1>
  <a class="btn btn-primary" href="<?= h(BASE_URL) ?>/comision/create">
    <i class="ti ti-plus"></i> Nueva
  </a>
</div>

<div class="card shadow-sm">
  <div class="table-responsive">
    <table class="table align-middle mb-0">
      <thead class="table-light">
        <tr>
          <th>#</th>
          <th>Título / Detalle</th>
          <th>Área</th>
          <th>Depto.</th>
          <th>Rango</th>
          <th>Planificación</th>
          <th>Estado</th>
          <th class="text-end">Acciones</th>
        </tr>
      </thead>
      <tbody>
        <?php if (empty($items)): ?>
          <tr>
            <td colspan="8" class="text-center text-secondary py-4">No hay comisiones registradas.</td>
          </tr>
        <?php else: ?>
          <?php foreach ($items as $c): ?>
            <?php
              $rol         = strtoupper($u['rol'] ?? '');
              $esCreador   = ((int)$u['id'] === (int)$c['creador_id']);
              $puedeVerConst = ($c['estado'] === 'APROBADA') && ($rol === 'ALCALDE' || $esCreador);

              $badge = 'secondary';
              if ($c['estado'] === 'PENDIENTE')  $badge = 'warning';
              if ($c['estado'] === 'APROBADA')   $badge = 'success';
              if ($c['estado'] === 'RECHAZADA')  $badge = 'danger';

              // Datos de movilidad si existen (pueden no estar en esquemas antiguos)
              $chofer   = $c['chofer_nombre']       ?? '';
              $vehiculo = $c['vehiculo_nombre']     ?? '';
              $origen   = $c['origen_ciudad']       ?? '';
              $destIda  = $c['destino_ida_ciudad']  ?? '';
              $destRet  = $c['destino_retorno_ciudad'] ?? '';
            ?>
            <tr>
              <td><?= (int)$c['id'] ?></td>

              <td>
                <div class="fw-semibold">
                  <a class="link-underline link-underline-opacity-0" href="<?= h(BASE_URL) ?>/comision/show/<?= (int)$c['id'] ?>">
                    <?= h($c['titulo']) ?>
                  </a>
                </div>

                <?php if (!empty($c['participantes_text'])): ?>
                  <div class="small text-secondary">
                    <i class="ti ti-users"></i>
                    Participantes: <?= h($c['participantes_text']) ?>
                  </div>
                <?php endif; ?>

                <?php if ($chofer || $vehiculo): ?>
                  <div class="small text-secondary">
                    <i class="ti ti-steering-wheel"></i>
                    Chofer: <b><?= h($chofer ?: '—') ?></b> &nbsp; | &nbsp;
                    Vehículo: <b><?= h($vehiculo ?: '—') ?></b>
                  </div>
                <?php endif; ?>

                <?php if ($origen || $destIda || $destRet): ?>
                  <div class="small text-secondary">
                    <i class="ti ti-road"></i>
                    Traslado: <?= h($origen ?: '—') ?> → <?= h($destIda ?: '—') ?> → <?= h($destRet ?: '—') ?>
                  </div>
                <?php endif; ?>

                <?php if (!empty($c['const_codigo'])): ?>
                  <div class="small">
                    <span class="badge bg-light text-dark border"><i class="ti ti-file-certificate"></i> <?= h($c['const_codigo']) ?></span>
                  </div>
                <?php endif; ?>
              </td>

              <td><?= h($c['area_nombre']) ?></td>
              <td><?= h($c['depto_nombre']) ?></td>
              <td><?= h($c['fecha_inicio']) ?> → <?= h($c['fecha_fin']) ?></td>

              <td>
                <?php if (!empty($c['plan_ruta'])): ?>
                  <a class="btn btn-sm btn-outline-secondary" href="<?= h($c['plan_ruta']) ?>" target="_blank">
                    <i class="ti ti-file-description"></i> Ver
                  </a>
                <?php else: ?>
                  <span class="text-secondary small">—</span>
                <?php endif; ?>
              </td>

              <td>
                <span class="badge bg-<?= $badge ?>"><?= h($c['estado']) ?></span>
              </td>

              <td class="text-end">
                <!-- Ver detalle (siempre disponible para creador, alcalde, admin) -->
                <?php if ($esCreador || in_array($rol, ['ALCALDE','ADMIN'], true)): ?>
                  <a class="btn btn-sm btn-outline-dark"
                     href="<?= h(BASE_URL) ?>/comision/show/<?= (int)$c['id'] ?>">
                    <i class="ti ti-eye"></i> Ver detalle
                  </a>
                <?php endif; ?>

                <!-- Aprobar / Rechazar (solo alcalde cuando está pendiente) -->
                <?php if ($rol === 'ALCALDE' && $c['estado'] === 'PENDIENTE'): ?>
                  <a class="btn btn-sm btn-outline-success"
                     href="<?= h(BASE_URL) ?>/comision/aprobar/<?= (int)$c['id'] ?>">
                    <i class="ti ti-check"></i> Aprobar/Rechazar
                  </a>
                <?php endif; ?>

                <!-- Constancia (si aprobada y alcalde o creador) -->
                <?php if ($puedeVerConst): ?>
                  <a class="btn btn-sm btn-outline-primary"
                     href="<?= h(BASE_URL) ?>/comision/constancia/<?= (int)$c['id'] ?>">
                    <i class="ti ti-file-certificate"></i> Constancia
                  </a>
                <?php endif; ?>

                <!-- PDF Firmado (si existe y es creador o alcalde) -->
                <?php if (!empty($c['const_firmado']) && ($esCreador || $rol === 'ALCALDE')): ?>
                  <a class="btn btn-sm btn-outline-secondary"
                     target="_blank" href="<?= h($c['const_firmado']) ?>">
                    <i class="ti ti-file-check"></i> Firmado
                  </a>
                <?php endif; ?>
              </td>
            </tr>
          <?php endforeach; ?>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require __DIR__ . '/../layout/footer.php'; ?>
