<?php require __DIR__ . '/../layout/header.php'; ?>

<style>
  /* ====== Look & feel institucional ====== */
  .panel-soft{
    border:1px solid var(--line-soft,#e9edf3);
    background:linear-gradient(180deg,#ffffff 0%,#fbfcfe 100%);
    border-radius:14px;
  }
  .meta-chip{
    display:inline-flex;align-items:center;gap:.45rem;
    border:1px solid rgba(2,6,23,.06);background:#fff;
    padding:.34rem .58rem;border-radius:999px;font-size:.84rem;
  }
  .kpi-box{
    display:flex;align-items:center;justify-content:space-between;
    gap:.6rem;padding:.55rem .7rem;border-radius:10px;background:#fff;
    border:1px dashed rgba(2,6,23,.08);
  }
  .kpi-total{background:#0d6efd0f;border:1px solid #cfe2ff;border-radius:10px;padding:.75rem .85rem;}
  .text-mono{font-variant-numeric:tabular-nums;}
  .section-title{font-weight:600;}
  .badge-soft{background:#eef2ff;color:#2b4862;border:1px solid #dbe4ff;}

  /* ====== Tabla compacta de participantes ====== */
  .tbl-wrap{border:1px solid var(--line-soft,#e9edf3);border-radius:12px;overflow:hidden;}
  .tbl{width:100%;border-collapse:separate;border-spacing:0;font-size:.93rem;line-height:1.15;}
  .tbl thead th{
    position:sticky;top:0;z-index:1;background:#f6f8fc;
    border-bottom:1px solid #e8edf5;font-weight:600;
  }
  .tbl th,.tbl td{
    padding:.42rem .6rem; /* 👈 compacta */
    vertical-align:middle;
  }
  .tbl tbody tr:nth-child(even){background:#fafbff;}
  .tbl tfoot th{background:#f6f8fc;border-top:1px solid #e8edf5;}
  .tbl .num{font-variant-numeric:tabular-nums;white-space:nowrap;}
  .pill{
    display:inline-flex;align-items:center;gap:.3rem;
    padding:.12rem .44rem;border-radius:999px;font-size:.72rem;
    background:#eaf3ff;color:#0b63ce;border:1px solid #cfe2ff;white-space:nowrap;
  }
  .pill--integrante{background:#eef2ff;color:#334155;border-color:#e5e7eb;}
  @media (max-width:575.98px){ .grid-3{grid-template-columns:1fr !important;} .tbl{font-size:.9rem;} }
</style>

<h1 class="h5 mb-3"><i class="ti ti-info-circle"></i> Detalle de comisión</h1>

<?php
  /* ===== Estado y días ===== */
  $estado = (string)($item['estado'] ?? 'PENDIENTE');
  $badge = $estado==='APROBADA'?'success':($estado==='RECHAZADA'?'danger':($estado==='PENDIENTE'?'warning':'secondary'));
  $dias=0; $diasTxt='';
  if (!empty($item['fecha_inicio']) && !empty($item['fecha_fin'])) {
    try { $ini=new DateTime($item['fecha_inicio']); $fin=new DateTime($item['fecha_fin']); $dias=$ini->diff($fin)->days + 1; $diasTxt=$dias.' día'.($dias>1?'s':''); } catch(Throwable $e){}
  }

  /* ===== Combustible y viáticos ===== */
  $comb      = $movilidad['combustible'] ?? [];
  $combCosto = (float)($comb['costo_usd'] ?? ($comb['costo'] ?? 0));
  $tipoComb  = (string)($comb['tipo'] ?? 'GASOLINA');

  $viaticosTotal = (float)($viaticos['total_global'] ?? 0);
  $granTotal     = $viaticosTotal + $combCosto;

  /* ===== Participantes (compacto, sin columna Rol) ===== */
  $chips   = array_filter(array_map('trim', explode(',', (string)($item['participantes_text'] ?? ''))));
  $partSis = $participantesSistema ?? [];
  $chofer  = trim((string)($movilidad['chofer'] ?? $item['chofer_nombre'] ?? ''));

  $mapVia=[]; foreach(($viaticos['detalles'] ?? []) as $r){
    $k=mb_strtolower(trim((string)$r['nombre'])); if($k==='') continue;
    $mapVia[$k]=['dias'=>(int)($r['dias'] ?? $dias),'viatico'=>(float)($r['monto'] ?? 0.0)];
  }

  $seen=[]; $filas=[];
  foreach ($partSis as $ps){
    $nom=trim((string)($ps['nombre'] ?? '')); if($nom==='') continue;
    $key=mb_strtolower($nom); if(isset($seen[$key])) continue; $seen[$key]=1;
    $isChofer = ($chofer!=='' && $key===mb_strtolower($chofer));
    $via = $mapVia[$key]['viatico'] ?? 0.0; $d=$mapVia[$key]['dias'] ?? $dias;
    $fondo = $isChofer ? $combCosto : 0.0;
    $filas[]=['nombre'=>$nom,'tipo'=>$isChofer?'Chofer':'Integrante','dias'=>$d,'via'=>$via,'fondo'=>$fondo,'total'=>$via+$fondo];
  }
  foreach ($chips as $c){
    $nom=trim((string)$c); if($nom==='') continue;
    $key=mb_strtolower($nom); if(isset($seen[$key])) continue; $seen[$key]=1;
    $isChofer = ($chofer!=='' && $key===mb_strtolower($chofer));
    $via = $mapVia[$key]['viatico'] ?? 0.0; $d=$mapVia[$key]['dias'] ?? $dias;
    $fondo = $isChofer ? $combCosto : 0.0;
    $filas[]=['nombre'=>$nom,'tipo'=>$isChofer?'Chofer':'Integrante','dias'=>$d,'via'=>$via,'fondo'=>$fondo,'total'=>$via+$fondo];
  }
  if ($chofer!==''){
    $key=mb_strtolower($chofer);
    if(!isset($seen[$key])){
      $via = $mapVia[$key]['viatico'] ?? 0.0; $d=$mapVia[$key]['dias'] ?? $dias;
      $filas[]=['nombre'=>$chofer,'tipo'=>'Chofer','dias'=>$d,'via'=>$via,'fondo'=>$combCosto,'total'=>$via+$combCosto];
    }
  }

  $totVia=0; $totFondo=0; $totPers=0;
  foreach($filas as $f){ $totVia+=$f['via']; $totFondo+=$f['fondo']; $totPers+=$f['total']; }
?>

<!-- ===== Encabezado ===== -->
<div class="card p-3 mb-3 panel-soft">
  <div class="row g-3">
    <div class="col-12 d-flex flex-wrap gap-2 align-items-center">
      <span class="meta-chip"><i class="ti ti-calendar"></i> <b>Rango:</b>&nbsp;<?= h($item['fecha_inicio']) ?> → <?= h($item['fecha_fin']) ?> <?= $diasTxt ? '· '.$diasTxt : '' ?></span>
      <?php if (!empty($item['area_nombre'])): ?>
        <span class="meta-chip"><i class="ti ti-building"></i> <?= h($item['area_nombre']) ?></span>
      <?php endif; ?>
      <?php if (!empty($item['department_nombre'])): ?>
        <span class="meta-chip"><i class="ti ti-building-arch"></i> <?= h($item['department_nombre']) ?></span>
      <?php endif; ?>
      <span class="meta-chip"><i class="ti ti-flag"></i> Estado: <span class="badge bg-<?= $badge ?> ms-1"><?= h($estado) ?></span></span>
    </div>
    <div class="col-md-8">
      <div class="mb-1"><b>Título:</b> <?= h($item['titulo']) ?></div>
      <div class="mb-2"><b>Descripción:</b><br><?= nl2br(h($item['descripcion'])) ?></div>
    </div>
    <div class="col-md-4">
      <div class="section-title"><i class="ti ti-file-description"></i> Documento de planificación</div>
      <?php if (!empty($item['plan_ruta'])): ?>
        <a class="btn btn-sm btn-outline-secondary mt-2" href="<?= h($item['plan_ruta']) ?>" target="_blank"><i class="ti ti-file"></i> Ver adjunto</a>
      <?php else: ?><div class="text-secondary">No se adjuntó planificación.</div><?php endif; ?>
    </div>
  </div>
</div>

<!-- ===== Traslado & combustible ===== -->
<?php if (!empty($movilidad)): ?>
<div class="card p-3 mb-3">
  <div class="section-title mb-2"><i class="ti ti-road"></i> Traslado y combustible</div>
  <div class="row g-3">
    <div class="col-md-6">
      <div><b>Origen:</b> <?= h($movilidad['origen'] ?? '—') ?></div>
      <div><b>Destino (ida):</b> <?= h($movilidad['destino'] ?? '—') ?></div>
      <div><b>Destino (retorno):</b> <?= h($movilidad['retorno'] ?? '—') ?></div>
    </div>
    <div class="col-md-6">
      <div><b>Vehículo:</b> <?= h($movilidad['vehiculo'] ?? '—') ?></div>
      <div><b>Chofer:</b> <?= h($chofer ?: '—') ?></div>
      <div><b>Kilómetros totales:</b> <?= number_format((float)($movilidad['km_totales'] ?? 0), 2) ?> km</div>

      <?php
        $km_gal=$comb['km_por_galon'] ?? null; $galones=$comb['galones'] ?? null; $litros=$comb['litros'] ?? null;
        $precio_gal=$comb['precio_galon'] ?? null; $precio_li=$comb['precio_litro'] ?? null; $usaGal=($km_gal!==null && $galones!==null && $precio_gal!==null);
      ?>
      <?php if ($usaGal): ?>
        <div class="small text-secondary mt-1">
          Combustible (<?= h($tipoComb) ?>):
          <?= number_format((float)$galones,2) ?> gal × $<?= number_format((float)$precio_gal,2) ?>/gal · rend. ≈ <?= number_format((float)$km_gal,1) ?> km/gal
          ⇒ <b>$<?= number_format($combCosto,2) ?></b><?php if ($litros !== null): ?> <span class="text-muted"> (~<?= number_format((float)$litros,2) ?> L)</span><?php endif; ?>
        </div>
      <?php else: ?>
        <div class="small text-secondary mt-1">
          Combustible (<?= h($tipoComb) ?>):
          <?= number_format((float)($litros ?? 0),2) ?> L × $<?= number_format((float)($precio_li ?? 0),2) ?>/L · rend. ≈ <?= number_format((float)($comb['km_por_litro'] ?? 0),1) ?> km/L
          ⇒ <b>$<?= number_format($combCosto,2) ?></b>
        </div>
      <?php endif; ?>

      <?php if ($chofer): ?>
        <div class="alert alert-info py-2 mt-2 mb-0">
          <i class="ti ti-gas-station"></i>
          El <b>fondo de combustible estimado</b> ($<?= number_format($combCosto,2) ?>)
          se <b>acredita al chofer</b> <u><?= h($chofer) ?></u>.
        </div>
      <?php endif; ?>
    </div>
  </div>
</div>
<?php endif; ?>

<!-- ===== Participantes (tabla compacta) ===== -->
<div class="card p-3 mb-3">
  <div class="d-flex justify-content-between align-items-center mb-2">
    <div class="section-title"><i class="ti ti-users-group"></i> Participantes y montos</div>
    <div class="text-secondary small">Cálculo de viáticos: <?= h($viaticos['formula'] ?? '') ?> (por persona)</div>
  </div>

  <div class="tbl-wrap">
    <div class="table-responsive">
      <table class="tbl align-middle">
        <thead>
          <tr>
            <th style="min-width:220px">Funcionario / Participante</th>
            <th style="min-width:100px" class="text-center">Tipo</th>
            <th style="min-width:60px"  class="text-center">Días</th>
            <th style="min-width:120px" class="text-end">Viático (USD)</th>
            <th style="min-width:150px" class="text-end">Fondo combust. (USD)</th>
            <th style="min-width:140px" class="text-end">Total persona (USD)</th>
          </tr>
        </thead>
        <tbody>
        <?php if (empty($filas)): ?>
          <tr><td colspan="6" class="text-center text-secondary">Sin participantes registrados.</td></tr>
        <?php else: foreach ($filas as $r): ?>
          <tr>
            <td class="fw-semibold"><?= h($r['nombre']) ?></td>
            <td class="text-center">
              <?php if ($r['tipo']==='Chofer'): ?>
                <span class="pill"><i class="ti ti-steering-wheel"></i> Chofer</span>
              <?php else: ?>
                <span class="pill pill--integrante"><i class="ti ti-user"></i> Integrante</span>
              <?php endif; ?>
            </td>
            <td class="text-center"><?= (int)$r['dias'] ?></td>
            <td class="text-end num"><?= number_format((float)$r['via'],2) ?></td>
            <td class="text-end num"><?= number_format((float)$r['fondo'],2) ?></td>
            <td class="text-end num fw-semibold"><?= number_format((float)$r['total'],2) ?></td>
          </tr>
        <?php endforeach; endif; ?>
        </tbody>
        <tfoot>
          <tr>
            <th colspan="3" class="text-end">Totales</th>
            <th class="text-end num"><?= number_format($totVia,2) ?></th>
            <th class="text-end num"><?= number_format($totFondo,2) ?></th>
            <th class="text-end num"><?= number_format($totPers,2) ?></th>
          </tr>
        </tfoot>
      </table>
    </div>
  </div>
</div>

<!-- ===== Resumen financiero ===== -->
<div class="card p-3 mb-3 panel-soft">
  <div class="d-flex align-items-center justify-content-between mb-2">
    <div class="section-title"><i class="ti ti-report-money"></i> Resumen financiero</div>
    <span class="badge rounded-pill badge-soft">Estimado</span>
  </div>
  <div class="d-grid grid-3" style="grid-template-columns:repeat(3,1fr);gap:.6rem;">
    <div class="kpi-box"><span><i class="ti ti-users"></i> Total Viáticos</span><strong class="text-mono"><?= number_format($viaticosTotal,2) ?></strong></div>
    <div class="kpi-box"><span><i class="ti ti-gas-station"></i> Total Combustible</span><strong class="text-mono"><?= number_format($combCosto,2) ?></strong></div>
    <div class="kpi-total d-flex align-items-center justify-content-between">
      <span><i class="ti ti-sum"></i> TOTAL GENERAL</span>
      <strong class="h6 mb-0 text-mono text-brand" style="font-weight:700;"><?= number_format($granTotal,2) ?></strong>
    </div>
  </div>
  <div class="form-text mt-2">El total general es la suma de viáticos + combustible. El fondo de combustible se acredita al chofer.</div>
</div>

<div class="d-flex gap-2">
  <a class="btn btn-light" href="<?= h(BASE_URL) ?>/comision/index"><i class="ti ti-arrow-back-up"></i> Volver</a>
  <?php if (($item['estado'] ?? '') === 'APROBADA' && !empty($item['id'])): ?>
    <a class="btn btn-outline-primary" href="<?= h(BASE_URL) ?>/comision/constancia/<?= (int)$item['id'] ?>">
      <i class="ti ti-file-certificate"></i> Ver constancia
    </a>
  <?php endif; ?>
</div>

<?php require __DIR__ . '/../layout/footer.php'; ?>
