<?php require __DIR__ . '/../layout/header.php'; ?>
<?php
  $u = $u ?? user();
  $nombre = $u['nombre'] ?? 'Usuario';

  // ===== Helpers Donut =====
  /** Convierte filas -> segmentos de pastel: [pct, label, value] */
  function serie_pie(array $rows, string $labelKey, string $valueKey): array {
    $total = 0.0;
    foreach ($rows as $r) { $total += (float)($r[$valueKey] ?? 0); }
    if ($total <= 0) return [];
    $out = [];
    foreach ($rows as $r) {
      $v = (float)($r[$valueKey] ?? 0);
      if ($v <= 0) continue;
      $pct = ($v / $total) * 100;
      $out[] = ['pct'=>$pct, 'label'=>(string)$r[$labelKey], 'value'=>$v];
    }
    return $out;
  }

  // Segmentos para donuts
  $pieEstados = serie_pie($estado ?? [], 'nombre', 'valor');
  $pieAreas   = serie_pie($topAreas ?? [], 'area', 'total'); // &uacute;ltimos 30 d&iacute;as
?>
<style>
  :root{ --line:#e6eaf1; --ink:#0f172a; --muted:#64748b; --brand:#2b4862; }
  .panel{border:1px solid var(--line);border-radius:14px;background:#fff;}
  .kpi{border:1px solid var(--line);border-radius:14px;background:#fff;padding:12px;}
  .kpi b{font-size:1.25rem}
  .muted{color:var(--muted)}
  .mini{font-size:.82rem}
  .spark{width:100%;height:60px}
  .tbl{width:100%;border-collapse:separate;border-spacing:0}
  .tbl th,.tbl td{padding:.5rem .6rem;border-bottom:1px solid var(--line)}
  .tbl thead th{background:#f6f8fc}

  /* Donuts */
  .donut{ width:100%; max-width:260px; aspect-ratio:1/1; }
  .donut circle.track{ stroke:#eef2f7; }
  .legend{ list-style:none; padding:0; margin:0; }
  .legend li{ display:flex; align-items:center; gap:.5rem; font-size:.9rem; margin:.25rem 0; }
  .legend .swatch{ width:12px; height:12px; border-radius:3px; display:inline-block; border:1px solid rgba(0,0,0,.06); }
</style>

<h1 class="h5 mb-3"><i class="ti ti-gauge"></i> Panel de control</h1>

<!-- ===== KPIs ===== -->
<div class="row g-2 mb-3">
  <?php $pri = array_slice($kpis ?? [], 0, 4); foreach ($pri as $k): ?>
    <div class="col-12 col-sm-6 col-lg-3">
      <div class="kpi">
        <div class="muted mini"><?= h($k['label']) ?></div>
        <b><?= h($k['value']) ?><?= !empty($k['unit']) ? ' '.h($k['unit']) : '' ?></b>
        <?php if (!empty($k['hint'])): ?><div class="mini muted"><?= h($k['hint']) ?></div><?php endif; ?>
      </div>
    </div>
  <?php endforeach; ?>
</div>

<!-- ===== Series (sparks) ===== -->
<div class="row g-2 mb-3">
  <div class="col-12 col-lg-6">
    <div class="panel p-2">
      <div class="d-flex justify-content-between align-items-center px-1">
        <div class="fw-semibold"><i class="ti ti-calendar-stats"></i> Comisiones por mes (12m)</div>
        <div class="mini muted">&uacute;ltimo: <?= isset($trends['comisiones_mes']) ? (int)end($trends['comisiones_mes']) : 0 ?></div>
      </div>
      <?php
        $serie = $trends['comisiones_mes'] ?? array_fill(0,12,0);
        $d='M0 '.(60-($serie[0]??0));
        for($i=1;$i<count($serie);$i++){ $x=$i*(100/11); $y=60-$serie[$i]; $d.=" L{$x} {$y}"; }
      ?>
      <svg viewBox="0 0 100 60" class="spark" aria-label="Comisiones 12 meses">
        <path d="<?= $d ?>" fill="none" stroke="currentColor" stroke-width="2" opacity=".6"/>
      </svg>
    </div>
  </div>
  <div class="col-12 col-lg-6">
    <div class="panel p-2">
      <div class="d-flex justify-content-between align-items-center px-1">
        <div class="fw-semibold"><i class="ti ti-cash"></i> Gasto (vi&aacute;ticos+combustible) por mes (12m)</div>
        <div class="mini muted">USD</div>
      </div>
      <?php
        $serie = $trends['gasto_mes'] ?? array_fill(0,12,0);
        $max = max(1, (float)max($serie));
        $d='M0 '.(60-(($serie[0]??0)/$max)*60);
        for($i=1;$i<count($serie);$i++){ $x=$i*(100/11); $y=60-(($serie[$i]/$max)*60); $d.=" L{$x} {$y}"; }
      ?>
      <svg viewBox="0 0 100 60" class="spark" aria-label="Gasto 12 meses">
        <path d="<?= $d ?>" fill="none" stroke="currentColor" stroke-width="2" opacity=".6"/>
      </svg>
    </div>
  </div>
</div>

<!-- ===== Estado + Top &Aacute;reas ===== -->
<div class="row g-2 mb-3">
  <div class="col-12 col-lg-4">
    <div class="panel p-3">
      <div class="fw-semibold mb-2"><i class="ti ti-separator"></i> Desglose por estado</div>
      <?php
        $totalEstados = 0; foreach(($estado ?? []) as $e){ $totalEstados += (int)$e['valor']; }
        foreach(($estado ?? []) as $e):
          $val = (int)$e['valor']; $pct = $totalEstados>0 ? round(($val/$totalEstados)*100) : 0;
      ?>
        <div class="d-flex justify-content-between mini">
          <span><?= h($e['nombre']) ?></span>
          <span class="muted"><?= $val ?> (<?= $pct ?>%)</span>
        </div>
        <div class="progress mb-2" style="height:8px;border-radius:999px;">
          <div class="progress-bar" style="width:<?= $pct ?>%"></div>
        </div>
      <?php endforeach; ?>
      <div class="mini muted">Total: <?= (int)$totalEstados ?></div>
    </div>
  </div>

  <div class="col-12 col-lg-8">
    <div class="panel">
      <div class="p-3 border-bottom" style="border-color:#eef1f5"><b><i class="ti ti-trophy"></i> Rendimiento por &Aacute;rea (30 d&iacute;as)</b></div>
      <div class="table-responsive">
        <table class="tbl mb-0">
          <thead><tr><th>#</th><th>&Aacute;rea</th><th class="text-center">Total</th><th class="text-end">Tiempo prom.</th></tr></thead>
          <tbody>
            <?php $i=1; if(empty($topAreas)): ?>
              <tr><td colspan="4" class="text-center muted">Sin datos.</td></tr>
            <?php else: foreach($topAreas as $row): ?>
              <tr>
                <td><?= $i++ ?></td>
                <td class="fw-semibold"><i class="ti ti-building me-1 text-muted"></i><?= h($row['area']) ?></td>
                <td class="text-center"><?= (int)$row['total'] ?></td>
                <td class="text-end muted"><?= h($row['tiempo_prom']) ?></td>
              </tr>
            <?php endforeach; endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<!-- ===== Donuts ===== -->
<div class="row g-2">
  <!-- Donut por estado -->
  <div class="col-12 col-lg-6">
    <div class="panel p-3">
      <div class="fw-semibold mb-2"><i class="ti ti-chart-pie"></i> Estados (porcentaje)</div>
      <div class="d-flex align-items-center gap-3 flex-wrap">
        <?php
          $colors=['#7c93ff','#66c2a3','#f7b267','#f4978e','#8ecae6','#bdb2ff'];
          $circum = 2 * M_PI * 42; // r=42
          $offset = 0.0;
        ?>
        <svg viewBox="0 0 100 100" class="donut" aria-label="Estados">
          <circle class="track" cx="50" cy="50" r="42" fill="none" stroke-width="14"></circle>
          <?php foreach ($pieEstados as $i=>$seg):
            $len = $circum * ($seg['pct']/100);
            $dash = $len . ' ' . ($circum - $len);
            $rot = -90 + ($offset*360);
          ?>
            <circle cx="50" cy="50" r="42" fill="none" stroke-width="14"
                    stroke="<?= $colors[$i % count($colors)] ?>"
                    stroke-dasharray="<?= $dash ?>"
                    transform="rotate(<?= $rot ?> 50 50)"></circle>
          <?php $offset += ($seg['pct']/100); endforeach; ?>
          <circle cx="50" cy="50" r="28" fill="#fff"></circle>
          <text x="50" y="54" text-anchor="middle" font-size="10" fill="#64748b">
            <?php $tot = 0; foreach($estado as $e){ $tot+=(int)$e['valor']; } echo (int)$tot . ' total'; ?>
          </text>
        </svg>

        <ul class="legend m-0">
          <?php foreach ($pieEstados as $i=>$seg): ?>
            <li>
              <span class="swatch" style="background:<?= $colors[$i%count($colors)] ?>"></span>
              <?= h($seg['label']) ?>&nbsp;&mdash;&nbsp;<?= number_format($seg['pct'],1) ?>%
            </li>
          <?php endforeach; if (empty($pieEstados)): ?>
            <li class="muted">Sin datos.</li>
          <?php endif; ?>
        </ul>
      </div>
    </div>
  </div>

  <!-- Donut por &Aacute;rea (30 d&iacute;as) -->
  <div class="col-12 col-lg-6">
    <div class="panel p-3">
      <div class="fw-semibold mb-2"><i class="ti ti-chart-pie-2"></i> &Aacute;reas (30 d&iacute;as)</div>
      <div class="d-flex align-items-center gap-3 flex-wrap">
        <?php $circum2 = 2 * M_PI * 42; $offset2 = 0.0; ?>
        <svg viewBox="0 0 100 100" class="donut" aria-label="&Aacute;reas">
          <circle class="track" cx="50" cy="50" r="42" fill="none" stroke-width="14"></circle>
          <?php foreach ($pieAreas as $i=>$seg):
            $len = $circum2 * ($seg['pct']/100);
            $dash = $len . ' ' . ($circum2 - $len);
            $rot = -90 + ($offset2*360);
          ?>
            <circle cx="50" cy="50" r="42" fill="none" stroke-width="14"
                    stroke="<?= $colors[$i % count($colors)] ?>"
                    stroke-dasharray="<?= $dash ?>"
                    transform="rotate(<?= $rot ?> 50 50)"></circle>
          <?php $offset2 += ($seg['pct']/100); endforeach; ?>
          <circle cx="50" cy="50" r="28" fill="#fff"></circle>
          <text x="50" y="54" text-anchor="middle" font-size="10" fill="#64748b">
            <?php $totA=0; foreach($topAreas as $r){ $totA+=(int)$r['total']; } echo (int)$totA . ' casos'; ?>
          </text>
        </svg>

        <ul class="legend m-0">
          <?php foreach ($pieAreas as $i=>$seg): ?>
            <li>
              <span class="swatch" style="background:<?= $colors[$i%count($colors)] ?>"></span>
              <?= h($seg['label']) ?>&nbsp;&mdash;&nbsp;<?= number_format($seg['pct'],1) ?>%
            </li>
          <?php endforeach; if (empty($pieAreas)): ?>
            <li class="muted">Sin datos.</li>
          <?php endif; ?>
        </ul>
      </div>
    </div>
  </div>
</div>

<?php require __DIR__ . '/../layout/footer.php'; ?>
