<?php require __DIR__ . '/../layout/header.php'; ?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <h1 class="h5 mb-0"><i class="ti ti-building-warehouse"></i> Departamentos</h1>
  <a class="btn btn-primary" href="<?= h(BASE_URL) ?>/departamento/create"><i class="ti ti-plus"></i> Nuevo</a>
</div>
<div class="card shadow-sm">
  <div class="table-responsive">
    <table class="table align-middle mb-0">
      <thead class="table-light"><tr><th>#</th><th>Departamento</th><th>Área</th><th></th></tr></thead>
      <tbody>
        <?php foreach($items as $d): ?>
        <tr>
          <td><?= (int)$d['id'] ?></td>
          <td><?= h($d['nombre']) ?></td>
          <td><?= h($d['area_nombre']) ?></td>
          <td class="text-end">
            <a class="btn btn-sm btn-outline-primary" href="<?= h(BASE_URL) ?>/departamento/edit/<?= (int)$d['id'] ?>"><i class="ti ti-edit"></i></a>
            <a class="btn btn-sm btn-outline-danger" href="<?= h(BASE_URL) ?>/departamento/delete/<?= (int)$d['id'] ?>" onclick="return confirm('¿Eliminar departamento?')"><i class="ti ti-trash"></i></a>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require __DIR__ . '/../layout/footer.php'; ?>
