    </main>
  </div> <!-- /content-wrapper -->
</div> <!-- /app-shell -->

<script>
// ======= Tema (día/noche) con persistencia =======
(function(){
  const KEY = 'ui.theme';
  const html = document.documentElement;
  const btn  = document.getElementById('btnTheme');
  const ico  = document.getElementById('themeIcon');

  function apply(theme){
    html.setAttribute('data-bs-theme', theme);
    if (theme === 'dark') {
      ico.classList.remove('ti-sun-high','bi-brightness-high');
      ico.classList.add('ti-moon','bi-moon');
      btn.title = 'Cambiar a tema claro';
    } else {
      ico.classList.remove('ti-moon','bi-moon');
      ico.classList.add('ti-sun-high','bi-brightness-high');
      btn.title = 'Cambiar a tema oscuro';
    }
  }

  const saved = localStorage.getItem(KEY);
  if (saved === 'dark' || saved === 'light') {
    apply(saved);
  } else {
    const prefersDark = window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches;
    apply(prefersDark ? 'dark' : 'light');
  }

  btn?.addEventListener('click', () => {
    const current = html.getAttribute('data-bs-theme') === 'dark' ? 'dark' : 'light';
    const next = current === 'dark' ? 'light' : 'dark';
    localStorage.setItem(KEY, next);
    apply(next);
  });
})();

// ======= Sidebar móvil (open/close robusto) =======
(function(){
  const sidebar   = document.getElementById('appSidebar');
  const openBtn   = document.getElementById('btnOpenSidebar');
  const closeBtn  = document.getElementById('btnCloseSidebar');
  const backdrop  = document.getElementById('sidebarBackdrop');
  const body      = document.body;

  function open(){
    sidebar?.classList.add('open');
    backdrop?.classList.add('show');
    body?.classList.add('menu-open');
    openBtn?.setAttribute('aria-expanded', 'true');
  }
  function close(){
    sidebar?.classList.remove('open');
    backdrop?.classList.remove('show');
    body?.classList.remove('menu-open');
    openBtn?.setAttribute('aria-expanded', 'false');
  }

  // Eventos
  openBtn?.addEventListener('click', open);
  closeBtn?.addEventListener('click', close);
  backdrop?.addEventListener('click', close);

  // Cerrar con ESC
  document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape') close();
  });

  // Evitar que el scroll de fondo “empuje” cuando está abierto
  sidebar?.addEventListener('touchmove', (e) => {
    if (!sidebar.classList.contains('open')) return;
    // Permite scroll interno, evita scroll del body
    e.stopPropagation();
  }, {passive:false});

  // Ajuste en cambios de tamaño (al pasar a desktop resetear)
  window.addEventListener('resize', () => {
    if (window.innerWidth >= 992) close();
  });
})();
</script>

</body>
</html>

