<?php if (session_status() === PHP_SESSION_NONE) session_start(); ?>
<?php




  // ===== Helpers =====
  if (!function_exists('h')) { function h(?string $v): string { return htmlspecialchars((string)$v, ENT_QUOTES,'UTF-8'); } }

  // Usuario / rol
  $u   = $_SESSION['user'] ?? null;
  $rol = strtoupper($u['rol'] ?? '');
  $uid = (int)($u['id'] ?? 0);

  // Base y path actual
  $BASE = rtrim((string)(defined('BASE_URL') ? BASE_URL : ''), '/');
  $PATH = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH) ?? '/';

  // Activo por prefijo
  function isActive(string $path, string $current): string {
    $p = rtrim($path,'/'); if ($p==='') $p='/';
    return (strpos($current,$p)===0)?'active':'';
  }

  // Badges opcionales
  $badgeRecibidas = 0;

  // Logo institucional
  $LOGO = $BASE . '/img/logoc.png';
?>
<!doctype html>
<html lang="es" data-bs-theme="light">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover"/>
  <title><?= h(defined('APP_NAME') ? APP_NAME : 'Aplicación') ?></title>

  <!-- Bootstrap CSS -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">

  <!-- Iconos: Tabler (principal) + Bootstrap Icons (fallback) -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@tabler/icons-webfont@3.21.0/tabler-icons.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

  <style>
    :root{
      /* Colores institucionales */
      --brand:#2b4862;
      --ink:#0f172a;
      --ink-soft:#667085;
      --line:#e6eaf0;
      --surface:#ffffff;
      --surface-2:#f5f7fb;

      /* Sidebar */
      --sidebar:#0c1323;
      --sidebar-ink:#e6eeff;

      --radius:14px;
      --shadow:0 14px 30px rgba(2,6,23,.08);
      --glass:rgba(255,255,255,.96);

      --safe-top: env(safe-area-inset-top);
      --safe-bottom: env(safe-area-inset-bottom);
    }
    [data-bs-theme="dark"]{
      --surface:#0b1220; --surface-2:#0e1426; --line:#1f2937;
      --ink:#e5e7eb; --ink-soft:#94a3b8;
      --sidebar:#0b1220; --sidebar-ink:#d8e2ff;
      --glass:rgba(12,18,32,.94);
      --shadow:0 18px 40px rgba(0,0,0,.55);
    }

    html,body{height:100%;}
    body{ background:var(--surface-2); color:var(--ink); }

    .app-shell{ display:flex; min-height:100vh; width:100%; }

    /* ===== Sidebar ===== */
    .sidebar{
      width:272px; flex:0 0 272px;
      background:var(--sidebar); color:var(--sidebar-ink);
      padding:calc(18px + var(--safe-top)) 18px 18px;
      position:sticky; top:0; height:100dvh; overflow:auto;
      box-shadow: inset 0 0 0 1px rgba(255,255,255,.04);
      z-index:1065;
    }

    .brand-pro{ display:flex; align-items:center; gap:.9rem; }
    .logo-box{
      width:48px; height:48px; border-radius:14px;
      background:transparent; display:grid; place-items:center;
      border:1.5px solid rgba(255,255,255,.28);
      box-shadow: 0 2px 10px rgba(0,0,0,.25), inset 0 0 0 1px rgba(255,255,255,.06);
      overflow:hidden;
    }
    .logo-img{ width:100%; height:100%; object-fit:cover; display:block; }

    .brand-title{ color:#fff; font-weight:800; letter-spacing:.2px; line-height:1; }
    .brand-sub{ color:rgba(255,255,255,.75); font-size:.72rem; letter-spacing:.16em; text-transform:uppercase; line-height:1; }

    .menu-title{
      font-size:.72rem; letter-spacing:.14em; text-transform:uppercase;
      color:rgba(230,238,255,.75); margin:18px 8px 8px;
    }

    .nav-link-pro{
      display:flex; align-items:center; gap:.8rem;
      color:#e6eeff; text-decoration:none;
      padding:.78rem .9rem; border-radius:12px;
      transition:.15s ease; border:1px solid transparent;
    }
    .nav-link-pro:hover{ background:rgba(157,209,255,.10); border-color:rgba(157,209,255,.22); color:#fff; }
    .nav-link-pro.active{
      background:rgba(157,209,255,.14);
      border-color:rgba(157,209,255,.35);
      box-shadow: inset 0 0 0 1px rgba(157,209,255,.35);
      color:#fff;
    }

    /* Dropdown sobre topbar sticky */
    .topbar .dropdown-menu{ z-index:1070; }

    /* Íconos (Tabler y Bootstrap Icons alineados) */
    .nav-link-pro i{
      font-size:1.2rem;
      line-height:1;
      width:1.35rem;
      text-align:center;
    }

    /* ===== Topbar ===== */
    .content-wrapper{ flex:1; display:flex; flex-direction:column; min-width:0; }
    .topbar{
      position:sticky; top:0; z-index:1060;
      background:var(--glass); border-bottom:1px solid var(--line);
      backdrop-filter: blur(8px) saturate(1.05);
    }
    .topbar .bar{
      display:flex; align-items:center; justify-content:space-between;
      gap:12px; padding:8px 16px;
    }
    .tb-left{ display:flex; align-items:center; gap:12px; }
    .chip-logo{
      width:36px; height:36px; border-radius:10px; overflow:hidden;
      border:1.5px solid #cad8ff; background:#fff;
      display:grid; place-items:center;
    }
    .chip-logo img{ width:100%; height:100%; object-fit:cover; display:block; }
    .system-name{ font-weight:700; color:var(--brand); }
    .page-title{ font-weight:700; }
    .muted{ color:var(--ink-soft); }

    .tb-actions{ display:flex; align-items:center; gap:8px; }
    .btn-icon{
      display:grid; place-items:center; width:40px; height:40px;
      background:var(--surface); border:1px solid var(--line); border-radius:10px;
    }
    .user-trigger{
      display:flex; align-items:center; gap:.5rem; padding:4px 6px;
      background:var(--surface); border:1px solid var(--line); border-radius:10px;
    }
    .avatar{
      width:32px; height:32px; border-radius:9px; display:grid; place-items:center;
      background:#2b86ff; color:#fff; font-weight:800;
    }

    .content{ padding:20px; padding-bottom:calc(20px + var(--safe-bottom)); }

    /* Drawer móvil */
    @media (max-width: 992px){
      .sidebar{
        position:fixed; left:0; top:0; height:100dvh;
        width:85vw; max-width:360px; min-width:300px;
        transform:translateX(-100%); transition:transform .22s ease;
        box-shadow: 8px 0 28px rgba(0,0,0,.45);
      }
      .sidebar.open{ transform:translateX(0); }
      .sidebar-backdrop{
        position:fixed; inset:0; background:rgba(15,23,42,.45);
        backdrop-filter:blur(2px); opacity:0; visibility:hidden; transition:.2s;
        z-index:1064;
      }
      .sidebar-backdrop.show{ opacity:1; visibility:visible; }
      .system-name{ display:none; }
    }
    body.menu-open{ overflow:hidden; touch-action:none; }

    /* Scroll estético */
    .sidebar::-webkit-scrollbar{ width:10px; }
    .sidebar::-webkit-scrollbar-thumb{ background:rgba(255,255,255,.12); border-radius:8px; }
  </style>

  <!-- Bootstrap Bundle (incluye Popper) -->
  <script defer src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</head>
<body>
<div class="app-shell">

  <!-- ===== SIDEBAR ===== -->
  <aside id="appSidebar" class="sidebar" role="navigation" aria-label="Menú lateral">
    <div class="d-flex align-items-center justify-content-between mb-3">
      <div class="brand-pro">
        <div class="logo-box">
          <img src="<?= h($LOGO) ?>" alt="Logo" class="logo-img" decoding="async" referrerpolicy="no-referrer" />
        </div>
        <div>
          <div class="brand-title">COMAGA</div>
          <div class="brand-sub">Sistema de Comisiones</div>
        </div>
      </div>
      <button class="btn btn-sm btn-light d-lg-none" id="btnCloseSidebar" title="Cerrar" aria-label="Cerrar" style="border-radius:10px;">
        <i class="ti ti-x bi bi-x-lg"></i>
      </button>
    </div>

    <div class="menu">
      <?php if ($u): ?>
        <div class="menu-title">Navegación</div>
        <nav class="d-grid gap-1">
          <a class="nav-link-pro <?= isActive($BASE.'/dashboard', $PATH) ?>" href="<?= h($BASE) ?>/dashboard">
            <i class="ti ti-layout-dashboard bi bi-speedometer2" aria-hidden="true"></i>
            <span>Panel</span>
          </a>
          <a class="nav-link-pro <?= isActive($BASE.'/comision', $PATH) ?>" href="<?= h($BASE) ?>/comision/index">
            <!-- Cambio de icono: avión -> carro -->
            <i class="ti ti-car bi bi-car-front-fill" aria-hidden="true"></i>
            <span>Comisiones</span>
          </a>
          <a class="nav-link-pro <?= isActive($BASE.'/trazabilidad', $PATH) ?>" href="<?= h($BASE) ?>/trazabilidad/index">
            <i class="ti ti-route bi bi-signpost-2" aria-hidden="true"></i>
            <span>Trazabilidad</span>
            <?php if ($badgeRecibidas>0): ?>
              <span class="ms-auto badge bg-info-subtle text-info-emphasis"><?= (int)$badgeRecibidas ?></span>
            <?php endif; ?>
          </a>
        </nav>
<?php if (in_array($rol, ['ADMIN','ALCALDE'], true)): ?>
  <div class="nav-item dropdown">
    <a class="nav-link-pro dropdown-toggle <?= strpos($PATH, '/reportes') !== false ? 'active' : '' ?>" href="#" id="dropdownReportes" role="button" data-bs-toggle="dropdown" aria-expanded="false">
      <i class="ti ti-report-money bi bi-bar-chart-line-fill"></i>
      <span>Reportes</span>
    </a>
    <ul class="dropdown-menu dropdown-menu-dark border-0 shadow" aria-labelledby="dropdownReportes" style="border-radius:12px;">
      <li>
        <a class="dropdown-item d-flex align-items-center gap-2 <?= isActive($BASE.'/reportes/index', $PATH) ?>" href="<?= h($BASE) ?>/reportes/index">
          <i class="ti ti-graph"></i> Reporte general
        </a>
      </li>
      <li>
        <a class="dropdown-item d-flex align-items-center gap-2 <?= isActive($BASE.'/reportes/funcionario', $PATH) ?>" href="<?= h($BASE) ?>/reportes/funcionario">
          <i class="ti ti-user-search"></i> Por funcionario
        </a>
      </li>
    </ul>
  </div>
<?php endif; ?>


        <?php if ($rol === 'ADMIN'): ?>
          <div class="menu-title mt-2">Administración</div>
          <nav class="d-grid gap-1">
            <a class="nav-link-pro <?= isActive($BASE.'/user', $PATH) ?>" href="<?= h($BASE) ?>/user/index">
              <i class="ti ti-users bi bi-people-fill" aria-hidden="true"></i>
              <span>Usuarios</span>
            </a>
            <a class="nav-link-pro <?= isActive($BASE.'/area', $PATH) ?>" href="<?= h($BASE) ?>/area/index">
              <i class="ti ti-building bi bi-buildings" aria-hidden="true"></i>
              <span>Áreas</span>
            </a>
            <a class="nav-link-pro <?= isActive($BASE.'/departamento', $PATH) ?>" href="<?= h($BASE) ?>/departamento/index">
              <i class="ti ti-building-warehouse bi bi-houses-fill" aria-hidden="true"></i>
              <span>Departamentos</span>
            </a>
          </nav>
        <?php endif; ?>

        <div class="menu-title mt-2">Cuenta</div>
        <nav class="d-grid gap-1">
          <a class="nav-link-pro" href="<?= h($BASE) ?>/auth/logout">
            <i class="ti ti-logout bi bi-box-arrow-right" aria-hidden="true"></i>
            <span>Salir</span>
          </a>
        </nav>
      <?php else: ?>
        <nav class="d-grid gap-1">
          <a class="nav-link-pro active" href="<?= h($BASE) ?>/auth/login">
            <i class="ti ti-login bi bi-box-arrow-in-right" aria-hidden="true"></i>
            <span>Iniciar sesión</span>
          </a>
        </nav>
      <?php endif; ?>
    </div>
  </aside>
  <div class="sidebar-backdrop d-lg-none" id="sidebarBackdrop" aria-hidden="true"></div>

  <!-- ===== MAIN ===== -->
  <div class="content-wrapper">

    <!-- Topbar -->
    <header class="topbar">
      <div class="bar">
        <div class="tb-left">
          <button class="btn-icon d-lg-none" id="btnOpenSidebar" title="Menú" aria-controls="appSidebar" aria-expanded="false" aria-label="Abrir menú">
            <i class="ti ti-menu-2 bi bi-list"></i>
          </button>

          <div class="chip-logo">
            <img src="<?= h($LOGO) ?>" alt="Logo" decoding="async" referrerpolicy="no-referrer"/>
          </div>
          <div class="system-name">Sistema de Gestión de Comisiones</div>
        </div>

        <div class="page-title text-truncate">
          <?= h($pageTitle ?? 'Inicio') ?>
        </div>

        <div class="tb-actions">
          <!-- Tema -->
          <button class="btn-icon" id="btnTheme" type="button" title="Cambiar tema" aria-label="Cambiar tema">
            <i class="ti ti-sun-high bi bi-brightness-high" id="themeIcon"></i>
          </button>

          <?php if ($u): ?>
          <!-- Menú de usuario -->
          <div class="dropdown">
            <button class="user-trigger" type="button" data-bs-toggle="dropdown" data-bs-auto-close="outside"
                    aria-expanded="false" aria-haspopup="true" aria-label="Cuenta" id="userMenuBtn">
              <span class="avatar"><?= h(mb_substr($u['nombre'] ?? 'U', 0, 1)) ?></span>
              <span class="d-none d-md-inline muted" style="font-weight:600;"><?= h($u['nombre'] ?? '') ?></span>
              <i class="ti ti-chevron-down bi bi-caret-down-fill" aria-hidden="true"></i>
            </button>
            <ul class="dropdown-menu dropdown-menu-end shadow" aria-labelledby="userMenuBtn" style="border-radius:12px;">
              <li class="px-3 py-2">
                <div class="small text-muted mb-1">Sesión</div>
                <div class="fw-semibold"><?= h($u['nombre'] ?? '') ?></div>
                <div class="text-muted" style="font-size:.85rem;"><?= h($rol) ?></div>
              </li>
              <li><hr class="dropdown-divider"></li>
              <li>
                <a class="dropdown-item" href="<?= h($BASE) ?>/auth/logout">
                  <i class="ti ti-logout bi bi-box-arrow-right me-2"></i>Salir
                </a>
              </li>
            </ul>
          </div>
          <?php endif; ?>
        </div>
      </div>
    </header>

    <!-- ===== Aquí inicia el contenido específico de cada vista ===== -->
    <main class="content">
