<?php require __DIR__ . '/../layout/header.php'; ?>
<h1 class="h5 mb-3 d-flex align-items-center gap-2">
  <i class="ti ti-user-search"></i> Reporte por funcionario
</h1>

<div class="card p-3 mb-3 shadow-sm">
  <form class="row g-2">
    <div class="col-md-4">
      <label class="form-label small">Buscar (nombre/descr./comisión)</label>
      <input type="text" name="q" value="<?= h($q ?? '') ?>" class="form-control" placeholder="Texto libre…">
    </div>
    <div class="col-md-2">
      <label class="form-label small">Chofer</label>
      <input type="text" name="chofer" value="<?= h($chofer ?? '') ?>" class="form-control" placeholder="Nombre exacto">
    </div>
    <div class="col-md-2">
      <label class="form-label small">Desde</label>
      <input type="date" name="desde" value="<?= h($desde ?? '') ?>" class="form-control">
    </div>
    <div class="col-md-2">
      <label class="form-label small">Hasta</label>
      <input type="date" name="hasta" value="<?= h($hasta ?? '') ?>" class="form-control">
    </div>
    <div class="col-md-2 d-flex align-items-end gap-2">
      <button class="btn btn-primary w-100"><i class="ti ti-filter"></i> Filtrar</button>
      <a class="btn btn-light" href="?"><i class="ti ti-x"></i></a>
    </div>
  </form>
</div>

<?php
  $sumVia=0; $sumFondo=0; $sumTot=0;
  foreach ($data as $d){ $sumVia+=$d['viaticos']; $sumFondo+=$d['fondo']; $sumTot+=$d['total']; }
?>

<div class="row g-3 mb-3">
  <div class="col-md-4">
    <div class="card p-3 shadow-sm">
      <div class="small text-secondary">Total viáticos</div>
      <div class="h4 mb-0">$<?= number_format($sumVia,2) ?></div>
    </div>
  </div>
  <div class="col-md-4">
    <div class="card p-3 shadow-sm">
      <div class="small text-secondary">Fondo combustible (choferes)</div>
      <div class="h4 mb-0">$<?= number_format($sumFondo,2) ?></div>
    </div>
  </div>
  <div class="col-md-4">
    <div class="card p-3 shadow-sm">
      <div class="small text-secondary">Total general</div>
      <div class="h4 mb-0">$<?= number_format($sumTot,2) ?></div>
    </div>
  </div>
</div>

<div class="card p-3 shadow-sm">
  <div class="table-responsive">
    <table class="table table-sm align-middle">
      <thead class="table-light">
        <tr>
          <th>Funcionario</th>
          <th class="text-end">Viáticos</th>
          <th class="text-end">Fondo combustible</th>
          <th class="text-end">Total</th>
          <th class="text-end">Acciones</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($data as $row): ?>
        <tr>
          <td class="fw-semibold"><?= h($row['nombre']) ?></td>
          <td class="text-end"><?= number_format($row['viaticos'],2) ?></td>
          <td class="text-end"><?= number_format($row['fondo'],2) ?></td>
          <td class="text-end fw-bold"><?= number_format($row['total'],2) ?></td>
          <td class="text-end">
            <!-- Ver detalle inline -->
            <button class="btn btn-sm btn-outline-secondary" type="button" data-bs-toggle="collapse" data-bs-target="#d<?= md5($row['nombre']) ?>">
              <i class="ti ti-list-details"></i>
            </button>
            <!-- PDF de este funcionario (respeta filtros de fecha) -->
            <a class="btn btn-sm btn-outline-primary"
               href="<?= h(BASE_URL) ?>/reportes/funcionario_pdf?nombre=<?= urlencode($row['nombre']) ?>&desde=<?= urlencode($desde ?? '') ?>&hasta=<?= urlencode($hasta ?? '') ?>"
               target="_blank" title="Generar PDF">
              <i class="ti ti-file-download"></i>
            </a>
          </td>
        </tr>
        <tr class="collapse" id="d<?= md5($row['nombre']) ?>">
          <td colspan="5">
            <div class="table-responsive">
              <table class="table table-bordered table-sm mb-0">
                <thead class="table-light">
                  <tr>
                    <th>Comisión</th><th>Rango</th><th>Origen</th><th>Destino</th><th>Rol</th>
                    <th class="text-end">Viáticos</th>
                    <th class="text-end">Fondo comb.</th>
                    <th class="text-end">Total</th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach($row['items'] as $it): ?>
                  <tr>
                    <td><?= h($it['titulo']) ?></td>
                    <td><?= h($it['rango']) ?></td>
                    <td><?= h($it['origen']) ?></td>
                    <td><?= h($it['destino']) ?></td>
                    <td><?= $it['es_chofer'] ? '<span class="badge bg-info">Chofer</span>' : 'Participante' ?></td>
                    <td class="text-end"><?= number_format($it['viaticos'],2) ?></td>
                    <td class="text-end"><?= number_format($it['fondo'],2) ?></td>
                    <td class="text-end fw-semibold"><?= number_format($it['total'],2) ?></td>
                  </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
      <tfoot>
        <tr>
          <th>Total</th>
          <th class="text-end"><?= number_format($sumVia,2) ?></th>
          <th class="text-end"><?= number_format($sumFondo,2) ?></th>
          <th class="text-end"><?= number_format($sumTot,2) ?></th>
          <th></th>
        </tr>
      </tfoot>
    </table>
  </div>
</div>

<?php require __DIR__ . '/../layout/footer.php'; ?>
