<?php require __DIR__ . '/../layout/header.php'; ?>
<h1 class="h5 mb-3 d-flex align-items-center gap-2">
  <i class="ti ti-report-money"></i> Reportes de comisiones
</h1>

<!-- KPIs -->
<div class="row g-3 mb-3">
  <div class="col-12 col-md-4">
    <div class="card shadow-sm border-0" style="border-radius:14px;">
      <div class="card-body d-flex align-items-center justify-content-between">
        <div>
          <div class="text-secondary small">Vi&aacute;ticos</div>
          <div class="h4 mb-0">$<?= number_format($totViaticos,2) ?></div>
        </div>
        <i class="ti ti-cash" style="font-size:28px;"></i>
      </div>
    </div>
  </div>
  <div class="col-12 col-md-4">
    <div class="card shadow-sm border-0" style="border-radius:14px;">
      <div class="card-body d-flex align-items-center justify-content-between">
        <div>
          <div class="text-secondary small">Combustible</div>
          <div class="h4 mb-0">$<?= number_format($totCombustible,2) ?></div>
        </div>
        <i class="ti ti-gas-station" style="font-size:28px;"></i>
      </div>
    </div>
  </div>
  <div class="col-12 col-md-4">
    <div class="card shadow-sm border-0" style="border-radius:14px;">
      <div class="card-body d-flex align-items-center justify-content-between">
        <div>
          <div class="text-secondary small">Total general</div>
          <div class="h4 mb-0">$<?= number_format($totGeneral,2) ?></div>
        </div>
        <i class="ti ti-sum" style="font-size:28px;"></i>
      </div>
    </div>
  </div>
</div>

<!-- Filtros -->
<form class="card p-3 shadow-sm mb-3" method="get" action="">
  <div class="row g-2 align-items-end">
    <div class="col-12 col-md-3">
      <label class="form-label mb-1">Texto</label>
      <input class="form-control" type="text" name="q" value="<?= h($q) ?>" placeholder="T&iacute;tulo o descripci&oacute;n">
    </div>
    <div class="col-12 col-md-3">
      <label class="form-label mb-1">Chofer</label>
      <input class="form-control" type="text" name="ch" value="<?= h($chofer) ?>" placeholder="Nombre del chofer">
    </div>
    <div class="col-6 col-md-2">
      <label class="form-label mb-1">Desde</label>
      <input class="form-control" type="date" name="d" value="<?= h($desde) ?>">
    </div>
    <div class="col-6 col-md-2">
      <label class="form-label mb-1">Hasta</label>
      <input class="form-control" type="date" name="h" value="<?= h($hasta) ?>">
    </div>
    <div class="col-6 col-md-1">
      <label class="form-label mb-1">Estado</label>
      <select class="form-select" name="e">
        <option value="">Todos</option>
        <?php foreach (['APROBADA','RECHAZADA','PENDIENTE'] as $st): ?>
          <option value="<?= $st ?>" <?= $estado===$st?'selected':'' ?>><?= $st ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-12 d-flex gap-2">
      <button class="btn btn-primary"><i class="ti ti-filter"></i> Filtrar</button>
      <a class="btn btn-light" href="<?= h(BASE_URL) ?>/reportes/index"><i class="ti ti-eraser"></i> Limpiar</a>
      <a class="btn btn-outline-secondary ms-auto"
         href="<?= h(BASE_URL) ?>/reportes/index?<?= http_build_query(['q'=>$q,'ch'=>$chofer,'d'=>$desde,'h'=>$hasta,'e'=>$estado,'export'=>'csv']) ?>">
        <i class="ti ti-file-type-csv"></i> Exportar CSV
      </a>
    </div>
  </div>
</form>

<!-- Tops -->
<div class="row g-3 mb-3">
  <div class="col-md-6">
    <div class="card p-3 shadow-sm">
      <div class="fw-semibold mb-2"><i class="ti ti-steering-wheel"></i> Top choferes (vi&aacute;ticos)</div>
      <?php if (!empty($tops['chofer'])): ?>
        <?php foreach ($tops['chofer'] as $n=>$v): ?>
          <div class="d-flex justify-content-between border-bottom py-1">
            <div><?= h($n) ?></div>
            <div><span class="badge bg-light text-dark me-2"><?= (int)$v['count'] ?> comisiones</span>
                 <b>$<?= number_format((float)$v['monto'],2) ?></b></div>
          </div>
        <?php endforeach; ?>
      <?php else: ?><div class="text-secondary small">Sin datos</div><?php endif; ?>
    </div>
  </div>
  <div class="col-md-6">
    <div class="card p-3 shadow-sm">
      <div class="fw-semibold mb-2"><i class="ti ti-briefcase"></i> Top comisiones (total)</div>
      <?php if (!empty($tops['comisiones'])): ?>
        <?php foreach ($tops['comisiones'] as $r): ?>
          <div class="d-flex justify-content-between border-bottom py-1">
            <div class="text-truncate me-2" title="<?= h($r['titulo']) ?>">
              <a class="text-decoration-none" href="<?= h(BASE_URL) ?>/comision/show/<?= (int)$r['id'] ?>">
                <?= h($r['titulo']) ?>
              </a>
              <span class="text-secondary small"> · <?= h($r['fecha_inicio']) ?> → <?= h($r['fecha_fin']) ?></span>
            </div>
            <div><b>$<?= number_format((float)$r['gran_total'],2) ?></b></div>
          </div>
        <?php endforeach; ?>
      <?php else: ?><div class="text-secondary small">Sin datos</div><?php endif; ?>
    </div>
  </div>
</div>

<!-- Tabla -->
<div class="card shadow-sm">
  <div class="table-responsive">
    <table class="table align-middle mb-0" style="min-width:980px;">
      <thead class="table-light">
        <tr>
          <th>#</th>
          <th>T&iacute;tulo</th>
          <th>Rango</th>
          <th>Chofer</th>
          <th class="text-end">D&iacute;as</th>
          <th class="text-end">Part.</th>
          <th class="text-end">Vi&aacute;ticos</th>
          <th class="text-end">Combustible</th>
          <th class="text-end">Total</th>
          <th>Estado</th>
        </tr>
      </thead>
      <tbody>
        <?php if (empty($rows)): ?>
          <tr><td colspan="10" class="text-center text-secondary py-4">Sin resultados.</td></tr>
        <?php else: foreach ($rows as $r): ?>
          <tr>
            <td class="text-secondary"><?= (int)$r['id'] ?></td>
            <td class="text-truncate">
              <a class="text-decoration-none" href="<?= h(BASE_URL) ?>/comision/show/<?= (int)$r['id'] ?>"><?= h($r['titulo']) ?></a>
            </td>
            <td><?= h($r['fecha_inicio']) ?> → <?= h($r['fecha_fin']) ?></td>
            <td><?= h($r['chofer_nombre'] ?: '—') ?></td>
            <td class="text-end"><?= (int)$r['dias'] ?></td>
            <td class="text-end"><?= (int)$r['participantes_num'] ?></td>
            <td class="text-end">$<?= number_format((float)$r['viaticos_total'],2) ?></td>
            <td class="text-end">$<?= number_format((float)$r['combustible_costo'],2) ?></td>
            <td class="text-end fw-semibold">$<?= number_format((float)$r['gran_total'],2) ?></td>
            <td><span class="badge bg-<?= strtoupper($r['estado'])==='APROBADA'?'success':(strtoupper($r['estado'])==='RECHAZADA'?'danger':'secondary') ?>">
              <?= h(strtoupper($r['estado'] ?? '')) ?></span></td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require __DIR__ . '/../layout/footer.php'; ?>
