<?php require __DIR__ . '/../layout/header.php'; ?>

<h1 class="h5 mb-3 d-flex align-items-center gap-2">
  <i class="ti ti-route"></i>
  Trazabilidad &middot; <span class="text-secondary">M&oacute;dulo <?= h($modulo) ?></span>
</h1>

<!-- ===== KPIs ===== -->
<div class="row g-3 mb-3">
  <div class="col-12 col-md-4">
    <div class="card shadow-sm border-0" style="border-radius:14px;">
      <div class="card-body d-flex align-items-center justify-content-between">
        <div>
          <div class="text-secondary small">Eventos filtrados</div>
          <div class="h4 mb-0"><?= (int)$stats['total'] ?></div>
        </div>
        <i class="ti ti-activity heartbeat" style="font-size:28px;"></i>
      </div>
    </div>
  </div>
  <div class="col-6 col-md-4">
    <div class="card shadow-sm border-0" style="border-radius:14px;">
      <div class="card-body d-flex align-items-center justify-content-between">
        <div>
          <div class="text-secondary small">&Uacute;ltimas 24&nbsp;h</div>
          <div class="h4 mb-0"><?= (int)$stats['ult24'] ?></div>
        </div>
        <i class="ti ti-clock" style="font-size:28px;"></i>
      </div>
    </div>
  </div>
  <div class="col-6 col-md-4">
    <div class="card shadow-sm border-0" style="border-radius:14px;">
      <div class="card-body d-flex align-items-center justify-content-between">
        <div>
          <div class="text-secondary small">Acciones (top)</div>
          <div class="small">
            <?php $i=0; foreach($accCounts as $k=>$v){ if($i++>=3) break; ?>
              <span class="badge bg-light text-dark"><?= h($k) ?>: <?= (int)$v ?></span>
            <?php } ?>
          </div>
        </div>
        <i class="ti ti-list-details" style="font-size:28px;"></i>
      </div>
    </div>
  </div>
</div>

<!-- ===== Filtros ===== -->
<form class="card p-3 shadow-sm mb-3" method="get" action="">
  <div class="row g-2 align-items-end">
    <div class="col-12 col-md-3">
      <label class="form-label mb-1">Buscar</label>
      <input type="text" class="form-control" name="q" value="<?= h($q) ?>" placeholder="Texto libre&hellip;">
      <input type="hidden" name="mod" value="<?= h($modulo) ?>">
    </div>
    <div class="col-6 col-md-2">
      <label class="form-label mb-1">Acci&oacute;n</label>
      <select class="form-select" name="accion">
        <option value="">Todas</option>
        <?php foreach(array_keys($accCounts) as $acc): ?>
          <option value="<?= h($acc) ?>" <?= ($accion===$acc?'selected':'') ?>><?= h($acc) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-6 col-md-3">
      <label class="form-label mb-1">Usuario</label>
      <select class="form-select" name="usuario">
        <option value="">Todos</option>
        <?php foreach($usrCounts as $name=>$c): ?>
          <option value="<?= h($name) ?>" <?= ($usuario===$name?'selected':'') ?>><?= h($name) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-6 col-md-2">
      <label class="form-label mb-1">Desde</label>
      <input type="date" class="form-control" name="desde" value="<?= h($desde) ?>">
    </div>
    <div class="col-6 col-md-2">
      <label class="form-label mb-1">Hasta</label>
      <input type="date" class="form-control" name="hasta" value="<?= h($hasta) ?>">
    </div>

    <div class="col-12 d-flex gap-2 mt-2">
      <button class="btn btn-primary"><i class="ti ti-filter"></i> Filtrar</button>
      <a class="btn btn-light" href="?mod=<?= urlencode($modulo) ?>"><i class="ti ti-eraser"></i> Limpiar</a>
      <a class="btn btn-outline-secondary ms-auto" href="?mod=<?= urlencode($modulo) ?>&q=<?= urlencode($q) ?>&accion=<?= urlencode($accion) ?>&usuario=<?= urlencode($usuario) ?>&desde=<?= urlencode($desde) ?>&hasta=<?= urlencode($hasta) ?>&export=csv">
        <i class="ti ti-file-type-csv"></i> Exportar CSV
      </a>
    </div>
  </div>
</form>

<!-- ===== Tabla ===== -->
<div class="card shadow-sm">
  <div class="table-responsive">
    <table class="table align-middle mb-0" style="min-width:900px;">
      <thead class="table-light" style="position:sticky; top:0; z-index:5;">
        <tr>
          <th style="width:70px">#</th>
          <th style="width:180px">Fecha/Hora</th>
          <th style="width:140px">M&oacute;dulo</th>
          <th style="width:150px">Acci&oacute;n</th>
          <th style="width:220px">Usuario</th>
          <th style="width:90px">Ref</th>
          <th>Detalle</th>
        </tr>
      </thead>
      <tbody>
        <?php if (empty($logs)): ?>
          <tr><td colspan="7" class="text-center text-secondary py-4">Sin resultados con los filtros actuales.</td></tr>
        <?php else: foreach($logs as $l):
            $accion = strtoupper($l['accion'] ?? '');
            $map = [
              'CREAR' => 'primary',
              'APROBADA' => 'success',
              'RECHAZADA' => 'danger',
              'ADJUNTO_PLAN' => 'info',
              'CONSTANCIA' => 'secondary',
              'CONSTANCIA_GEN' => 'secondary',
              'CONSTANCIA_FIRMADA' => 'success',
              'ERR_*' => 'warning',
            ];
            $color = 'secondary';
            foreach($map as $k=>$v){
              if ($k === 'ERR_*' && str_starts_with($accion,'ERR_')) { $color = $v; break; }
              if ($accion === $k) { $color = $v; break; }
            }
            $user = (string)($l['usuario'] ?? '');
            $ini  = mb_substr($user,0,1);
            $ref  = trim((string)($l['ref_id'] ?? ''));
            $refLink = $ref !== '' ? '<a href="'.h(BASE_URL).'/comision/show/'.urlencode($ref).'" class="text-decoration-none">'.h($ref).'</a>' : '';
        ?>
        <tr>
          <td class="text-secondary"><?= (int)$l['id'] ?></td>
          <td>
            <div><?= h($l['fecha_hora']) ?></div>
            <div class="small text-secondary" data-reltime="<?= h($l['fecha_hora']) ?>"></div>
          </td>
          <td><span class="badge bg-light text-dark"><?= h($l['modulo']) ?></span></td>
          <td><span class="badge bg-<?= h($color) ?>"><?= h($accion) ?></span></td>
          <td>
            <div class="d-flex align-items-center gap-2">
              <div class="avatar rounded" style="width:28px;height:28px;background:#e0e7ff;color:#1e3a8a;font-weight:700;display:grid;place-items:center;"><?= h($ini) ?></div>
              <div>
                <div class="fw-semibold small"><?= h($user) ?></div>
              </div>
            </div>
          </td>
          <td><?= $refLink ?></td>
          <td>
            <div class="text-truncate" style="max-width: 520px;" title="<?= h($l['detalle']) ?>">
              <?= h($l['detalle']) ?>
            </div>
          </td>
        </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div>

<style>
.heartbeat { animation: hb 1.8s ease-in-out infinite; }
@keyframes hb { 0%,100%{ transform:scale(1); } 50%{ transform:scale(1.06);} }
</style>

<script>
// Tooltips
document.querySelectorAll('[title]').forEach(el=>{
  if (window.bootstrap && bootstrap.Tooltip) new bootstrap.Tooltip(el);
});

// Tiempo relativo
(function(){
  function rel(t){
    const ts = Date.parse(t); if (isNaN(ts)) return '';
    const s = Math.floor((Date.now() - ts)/1000); const abs = Math.abs(s);
    const unit=(v,u)=>v+' '+u+(v!==1?'s':'');
    if (abs < 60)   return 'hace ' + unit(abs,'segundo');
    if (abs < 3600) return 'hace ' + unit(Math.floor(abs/60),'minuto');
    if (abs < 86400)return 'hace ' + unit(Math.floor(abs/3600),'hora');
    return 'hace ' + unit(Math.floor(abs/86400),'d&iacute;a');
  }
  document.querySelectorAll('[data-reltime]').forEach(d=>{
    const t = d.getAttribute('data-reltime');
    d.innerHTML = rel(t);
  });
})();
</script>

<?php require __DIR__ . '/../layout/footer.php'; ?>
