<?php require __DIR__ . '/../layout/header.php'; ?>
<h1 class="h5 mb-3"><i class="ti ti-user-edit"></i> Editar usuario</h1>
<form method="post" class="card p-3 shadow-sm">
  <div class="row g-3">
    <div class="col-md-6">
      <label class="form-label">Nombre</label>
      <input name="nombre" class="form-control" value="<?= h($user['nombre']) ?>" required>
    </div>
    <div class="col-md-6">
      <label class="form-label">Correo</label>
      <input type="email" name="email" class="form-control" value="<?= h($user['email']) ?>" required>
    </div>
    <div class="col-md-4">
      <label class="form-label">Rol</label>
      <select name="rol_id" class="form-select" required>
        <?php foreach($roles as $r): ?>
          <option value="<?= (int)$r['id'] ?>" <?= ((int)$r['id']===(int)$user['rol_id'])?'selected':'' ?>>
            <?= h($r['nombre']) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-4">
      <label class="form-label">Área</label>
      <select name="area_id" id="area_id" class="form-select">
        <option value="">(Ninguna)</option>
        <?php foreach($areas as $a): ?>
          <option value="<?= (int)$a['id'] ?>" <?= ((int)$a['id']===(int)$user['area_id'])?'selected':'' ?>>
            <?= h($a['nombre']) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-4">
      <label class="form-label">Departamento</label>
      <select name="department_id" id="department_id" class="form-select">
        <option value="">(Ninguno)</option>
        <?php foreach($departamentos as $d): ?>
          <option value="<?= (int)$d['id'] ?>" <?= ((int)$d['id']===(int)$user['department_id'])?'selected':'' ?>>
            <?= h($d['nombre']) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-6">
      <label class="form-label">Cargo</label>
      <input name="cargo" class="form-control" value="<?= h($user['cargo']) ?>">
    </div>
    <div class="col-md-6">
      <label class="form-label">Nueva contraseña (opcional)</label>
      <input type="password" name="password" class="form-control" placeholder="Dejar en blanco para no cambiar">
    </div>
  </div>
  <div class="mt-3 d-flex gap-2">
    <a class="btn btn-light" href="<?= h(BASE_URL) ?>/user/index">Cancelar</a>
    <button class="btn btn-primary">Guardar cambios</button>
  </div>
</form>
<script>
document.getElementById('area_id').addEventListener('change', async (e) => {
  const areaId = e.target.value;
  const resp = await fetch('<?= h(BASE_URL) ?>/departamento/byArea/' + (areaId || 0));
  const items = await resp.json();
  const sel = document.getElementById('department_id');
  sel.innerHTML = '<option value="">(Ninguno)</option>';
  items.forEach(i => {
    const opt = document.createElement('option');
    opt.value = i.id; opt.textContent = i.nombre;
    sel.appendChild(opt);
  });
});
</script>
<?php require __DIR__ . '/../layout/footer.php'; ?>
