<?php require __DIR__ . '/../layout/header.php'; ?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <h1 class="h5 mb-0"><i class="ti ti-users"></i> Usuarios</h1>
  <a class="btn btn-primary" href="<?= h(BASE_URL) ?>/user/create"><i class="ti ti-plus"></i> Nuevo</a>
</div>
<div class="card shadow-sm">
  <div class="table-responsive">
    <table class="table align-middle mb-0">
      <thead class="table-light">
        <tr>
          <th>#</th><th>Nombre</th><th>Correo</th><th>Rol</th><th>Área</th><th>Departamento</th><th></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($users as $u): ?>
        <tr>
          <td><?= (int)$u['id'] ?></td>
          <td><?= h($u['nombre']) ?></td>
          <td><?= h($u['email']) ?></td>
          <td><span class="badge bg-secondary"><?= h($u['rol']) ?></span></td>
          <td><?= h($u['area_nombre']) ?></td>
          <td><?= h($u['depto_nombre']) ?></td>
          <td class="text-end">
            <a class="btn btn-sm btn-outline-primary" href="<?= h(BASE_URL) ?>/user/edit/<?= (int)$u['id'] ?>"><i class="ti ti-edit"></i></a>
            <a class="btn btn-sm btn-outline-danger" href="<?= h(BASE_URL) ?>/user/delete/<?= (int)$u['id'] ?>" onclick="return confirm('¿Eliminar usuario?')"><i class="ti ti-trash"></i></a>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require __DIR__ . '/../layout/footer.php'; ?>
