<?php
declare(strict_types=1);
ini_set('display_errors', '1');
error_reporting(E_ALL);
require_once __DIR__ . '/../app/config/env.php';
date_default_timezone_set(APP_TIMEZONE);

// Bootstrap
if (session_status() === PHP_SESSION_NONE) session_name(SESSION_NAME);
if (session_status() === PHP_SESSION_NONE) session_start();

require_once __DIR__ . '/../app/core/Controller.php';
require_once __DIR__ . '/../app/core/Model.php';
require_once __DIR__ . '/../app/helpers/util.php';

// Autoload básico (controllers y models)
spl_autoload_register(function ($class) {
    $paths = [__DIR__ . '/../app/controllers/', __DIR__ . '/../app/models/'];
    foreach ($paths as $p) {
        $file = $p . $class . '.php';
        if (file_exists($file)) { require_once $file; return; }
    }
});

// Router mínimo por segmentos: /controlador/accion/param1/param2
$basePath = parse_url(BASE_URL, PHP_URL_PATH) ?: '/';
$requestUri = $_SERVER['REQUEST_URI'] ?? '/';
$path = strtok($requestUri, '?');
if (str_starts_with($path, $basePath)) {
    $path = substr($path, strlen($basePath));
}
$path = trim($path, '/');

// Defaults
$controllerName = 'DashboardController';
$action = 'index';
$params = [];

if ($path !== '') {
    $segments = explode('/', $path);
    $controllerName = ucfirst($segments[0]) . 'Controller';
    $action = $segments[1] ?? 'index';
    $params = array_slice($segments, 2);
}

// ✅ Convertir parámetros numéricos a enteros (por strict_types=1)
$params = array_map(function ($param) {
    return ctype_digit($param) ? (int)$param : $param;
}, $params);

if (!class_exists($controllerName)) {
    http_response_code(404);
    echo "Controlador no encontrado: $controllerName";
    exit;
}

$controller = new $controllerName();
if (!method_exists($controller, $action)) {
    http_response_code(404);
    echo "Acción no encontrada: $action";
    exit;
}

call_user_func_array([$controller, $action], $params);
